/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.tracing;

import com.google.common.annotations.VisibleForTesting;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.propagation.Format;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.util.tracing.HttpServletCarrier;

public class GlobalTracer {
    private static final Tracer NOOP_TRACER = NoopTracerFactory.create();
    private static final Random RANDOM;
    private static volatile GlobalTracer INS;
    @VisibleForTesting
    final Tracer tracer;
    private double rate;
    private final ThreadLocal<Tracer> threadLocal = new ThreadLocal();

    public static synchronized void setup(Tracer tracer) {
        if (INS != null) {
            INS.close();
        }
        INS = new GlobalTracer(tracer);
    }

    public static GlobalTracer get() {
        return INS;
    }

    public static Tracer getTracer() {
        return INS.tracer();
    }

    public GlobalTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public synchronized void setSamplePercentage(double rate) {
        this.rate = rate / 100.0;
    }

    @VisibleForTesting
    public double getSampleRate() {
        return this.rate;
    }

    public boolean tracing() {
        return this.threadLocal.get() != null && this.threadLocal.get() != NOOP_TRACER && this.threadLocal.get().activeSpan() != null;
    }

    public SpanContext extract(HttpServletRequest request) {
        SpanContext spanContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpServletCarrier(request));
        if (spanContext != null) {
            this.threadLocal.set(this.tracer);
        }
        return spanContext;
    }

    private Tracer tracer() {
        Tracer tracer = this.threadLocal.get();
        if (tracer != null) {
            return tracer;
        }
        if (this.traced()) {
            this.threadLocal.set(this.tracer);
        } else {
            this.threadLocal.set(NOOP_TRACER);
        }
        return this.threadLocal.get();
    }

    public void clearContext() {
        this.threadLocal.remove();
    }

    private boolean traced() {
        return RANDOM.nextDouble() <= this.rate;
    }

    public void close() {
        this.tracer.close();
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
        INS = new GlobalTracer(NOOP_TRACER);
    }
}

