/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.function.ValueSourceRangeFilter;

public class FunctionRangeQuery
extends SolrConstantScoreQuery
implements PostFilter {
    final ValueSourceRangeFilter rangeFilt;

    public FunctionRangeQuery(ValueSourceRangeFilter filter) {
        super(filter);
        this.rangeFilt = filter;
        this.cost = 100;
    }

    @Override
    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        Map fcontext = ValueSource.newContext((IndexSearcher)searcher);
        Weight weight = this.rangeFilt.createWeight(searcher, ScoreMode.COMPLETE, 1.0f);
        return new FunctionRangeCollector(fcontext, weight);
    }

    class FunctionRangeCollector
    extends DelegatingCollector {
        final Map fcontext;
        final Weight weight;
        ValueSourceScorer scorer;
        int maxdoc;

        public FunctionRangeCollector(Map fcontext, Weight weight) {
            this.fcontext = fcontext;
            this.weight = weight;
        }

        @Override
        public void collect(int doc) throws IOException {
            assert (doc < this.maxdoc);
            if (this.scorer.matches(doc)) {
                this.leafDelegate.collect(doc);
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.maxdoc = context.reader().maxDoc();
            FunctionValues dv = FunctionRangeQuery.this.rangeFilt.getValueSource().getValues(this.fcontext, context);
            this.scorer = dv.getRangeScorer(this.weight, context, FunctionRangeQuery.this.rangeFilt.getLowerVal(), FunctionRangeQuery.this.rangeFilt.getUpperVal(), FunctionRangeQuery.this.rangeFilt.isIncludeLower(), FunctionRangeQuery.this.rangeFilt.isIncludeUpper());
        }
    }
}

