/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.monitor.CustomQueryHandler;
import org.apache.lucene.monitor.Presearcher;
import org.apache.lucene.monitor.QueryAnalyzer;
import org.apache.lucene.monitor.QueryTree;
import org.apache.lucene.monitor.TermWeightor;
import org.apache.lucene.monitor.TermsEnumTokenStream;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.BytesRefIterator;

public class TermFilteredPresearcher
extends Presearcher {
    public static final TermWeightor DEFAULT_WEIGHTOR = TermWeightor.DEFAULT;
    private final QueryAnalyzer extractor;
    private final TermWeightor weightor;
    private final Set<String> filterFields;
    private final List<CustomQueryHandler> queryHandlers = new ArrayList<CustomQueryHandler>();
    public static final String ANYTOKEN_FIELD = "__anytokenfield";
    public static final String ANYTOKEN = "__ANYTOKEN__";
    static final FieldType QUERYFIELDTYPE = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);

    public TermFilteredPresearcher() {
        this(DEFAULT_WEIGHTOR, Collections.emptyList(), Collections.emptySet());
    }

    public TermFilteredPresearcher(TermWeightor weightor, List<CustomQueryHandler> customQueryHandlers, Set<String> filterFields) {
        this.extractor = new QueryAnalyzer(customQueryHandlers);
        this.filterFields = filterFields;
        this.queryHandlers.addAll(customQueryHandlers);
        this.weightor = weightor;
    }

    @Override
    public final Query buildQuery(LeafReader reader, final BiPredicate<String, BytesRef> termAcceptor) {
        try {
            DocumentQueryBuilder queryBuilder = this.getQueryBuilder();
            for (final FieldInfo field : reader.getFieldInfos()) {
                Terms terms = reader.terms(field.name);
                if (terms == null) continue;
                TermsEnumTokenStream ts = new TermsEnumTokenStream((BytesRefIterator)terms.iterator());
                for (CustomQueryHandler handler : this.queryHandlers) {
                    ts = handler.wrapTermStream(field.name, ts);
                }
                ts = new FilteringTokenFilter(ts){
                    TermToBytesRefAttribute termAtt;
                    {
                        super(arg0);
                        this.termAtt = (TermToBytesRefAttribute)this.addAttribute(TermToBytesRefAttribute.class);
                    }

                    protected boolean accept() {
                        return !TermFilteredPresearcher.this.filterFields.contains(field.name) && termAcceptor.test(field.name, this.termAtt.getBytesRef());
                    }
                };
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)ts.addAttribute(TermToBytesRefAttribute.class);
                while (ts.incrementToken()) {
                    queryBuilder.addTerm(field.name, BytesRef.deepCopyOf((BytesRef)termAtt.getBytesRef()));
                }
                ts.close();
            }
            Query presearcherQuery = queryBuilder.build();
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add(presearcherQuery, BooleanClause.Occur.SHOULD);
            bq.add((Query)new TermQuery(new Term(ANYTOKEN_FIELD, ANYTOKEN)), BooleanClause.Occur.SHOULD);
            presearcherQuery = bq.build();
            if (!this.filterFields.isEmpty()) {
                bq = new BooleanQuery.Builder();
                bq.add(presearcherQuery, BooleanClause.Occur.MUST);
                Query filterQuery = this.buildFilterFields(reader);
                if (filterQuery != null) {
                    bq.add(filterQuery, BooleanClause.Occur.FILTER);
                    presearcherQuery = bq.build();
                }
            }
            return presearcherQuery;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query buildFilterFields(LeafReader reader) throws IOException {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String field : this.filterFields) {
            Query q = this.buildFilterClause(reader, field);
            if (q == null) continue;
            builder.add(q, BooleanClause.Occur.MUST);
        }
        BooleanQuery bq = builder.build();
        if (bq.clauses().size() == 0) {
            return null;
        }
        return bq;
    }

    private Query buildFilterClause(LeafReader reader, String field) throws IOException {
        BytesRef term;
        Terms terms = reader.terms(field);
        if (terms == null) {
            return null;
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        int docsInBatch = reader.maxDoc();
        TermsEnum te = terms.iterator();
        while ((term = te.next()) != null) {
            if (te.docFreq() != docsInBatch) {
                throw new IllegalArgumentException("Some documents in this batch do not have a term value of " + field + ":" + Term.toString((BytesRef)term));
            }
            bq.add((Query)new TermQuery(new Term(field, BytesRef.deepCopyOf((BytesRef)term))), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery built = bq.build();
        if (built.clauses().size() == 0) {
            return null;
        }
        return built;
    }

    protected DocumentQueryBuilder getQueryBuilder() {
        return new DocumentQueryBuilder(){
            Map<String, List<BytesRef>> terms = new HashMap<String, List<BytesRef>>();

            @Override
            public void addTerm(String field, BytesRef term) {
                List t = this.terms.computeIfAbsent(field, f -> new ArrayList());
                t.add(term);
            }

            @Override
            public Query build() {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                for (Map.Entry<String, List<BytesRef>> entry : this.terms.entrySet()) {
                    builder.add((Query)new TermInSetQuery(entry.getKey(), (Collection)entry.getValue()), BooleanClause.Occur.SHOULD);
                }
                return builder.build();
            }
        };
    }

    @Override
    public final Document indexQuery(Query query, Map<String, String> metadata) {
        QueryTree querytree = this.extractor.buildTree(query, this.weightor);
        Document doc = this.buildQueryDocument(querytree);
        for (String field : this.filterFields) {
            if (metadata == null || !metadata.containsKey(field)) continue;
            doc.add((IndexableField)new TextField(field, metadata.get(field), Field.Store.YES));
        }
        return doc;
    }

    protected Document buildQueryDocument(QueryTree querytree) {
        Map<String, BytesRefHash> fieldTerms = this.collectTerms(querytree);
        Document doc = new Document();
        for (Map.Entry<String, BytesRefHash> entry : fieldTerms.entrySet()) {
            doc.add((IndexableField)new Field(entry.getKey(), (TokenStream)new TermsEnumTokenStream(new BytesRefHashIterator(entry.getValue())), (IndexableFieldType)QUERYFIELDTYPE));
        }
        return doc;
    }

    protected Map<String, BytesRefHash> collectTerms(QueryTree querytree) {
        HashMap<String, BytesRefHash> fieldTerms = new HashMap<String, BytesRefHash>();
        querytree.collectTerms((String field, BytesRef term) -> {
            BytesRefHash tt = fieldTerms.computeIfAbsent((String)field, f -> new BytesRefHash());
            tt.add(term);
        });
        return fieldTerms;
    }

    static {
        QUERYFIELDTYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        QUERYFIELDTYPE.freeze();
    }

    protected class BytesRefHashIterator
    implements BytesRefIterator {
        final BytesRef scratch = new BytesRef();
        final BytesRefHash terms;
        final int[] sortedTerms;
        int upto = -1;

        BytesRefHashIterator(BytesRefHash terms) {
            this.terms = terms;
            this.sortedTerms = terms.sort();
        }

        public BytesRef next() {
            if (this.upto >= this.sortedTerms.length) {
                return null;
            }
            ++this.upto;
            if (this.sortedTerms[this.upto] == -1) {
                return null;
            }
            this.terms.get(this.sortedTerms[this.upto], this.scratch);
            return this.scratch;
        }
    }

    protected static interface DocumentQueryBuilder {
        public void addTerm(String var1, BytesRef var2) throws IOException;

        public Query build();
    }
}

