/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.stddev;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.stddev.StandardDeviationAggFunc;
import org.apache.kylin.measure.stddev.StdDevCounter;
import org.apache.kylin.measure.stddev.StdDevSerializer;
import org.apache.kylin.measure.stddev.StdDevTransformation;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;

public class StdDevSumMeasureType
extends MeasureType<StdDevCounter> {
    private final DataType dataType;
    public static final String FUNC_STDDEV_SUM = "STDDEV_SUM";
    public static final String DATATYPE_STDDEV = "stddev_sum";
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of((Object)"STDDEV_SUM", StandardDeviationAggFunc.class);

    public StdDevSumMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public MeasureIngester<StdDevCounter> newIngester() {
        return new MeasureIngester<StdDevCounter>(){
            StdDevCounter current = new StdDevCounter();

            @Override
            public StdDevCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                StdDevCounter counter = this.current;
                for (String v : values) {
                    if (v == null) continue;
                    counter.add(Double.parseDouble(v));
                }
                return counter;
            }

            @Override
            public void reset() {
                this.current = new StdDevCounter();
            }
        };
    }

    @Override
    public MeasureAggregator<StdDevCounter> newAggregator() {
        return new StdDevTransformation();
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    @Override
    public void adjustSqlDigest(List<MeasureDesc> measureDescs, SQLDigest sqlDigest) {
    }

    public static class Factory
    extends MeasureTypeFactory<StdDevCounter> {
        @Override
        public MeasureType<StdDevCounter> createMeasureType(String funcName, DataType dataType) {
            return new StdDevSumMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return StdDevSumMeasureType.FUNC_STDDEV_SUM;
        }

        @Override
        public String getAggrDataTypeName() {
            return StdDevSumMeasureType.DATATYPE_STDDEV;
        }

        @Override
        public Class<? extends DataTypeSerializer<StdDevCounter>> getAggrDataTypeSerializer() {
            return StdDevSerializer.class;
        }
    }
}

