/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.util;

import java.io.IOException;
import org.apache.kylin.stream.core.util.RetryCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryCaller {
    public static final int[] RETRY_BACKOFF = new int[]{1, 2, 3, 5, 7};
    private static final Logger logger = LoggerFactory.getLogger(RetryCaller.class);
    private int retries;
    private int pauseTimeInMs;

    public RetryCaller(int retries, int pauseTimeInMs) {
        this.retries = retries;
        this.pauseTimeInMs = pauseTimeInMs;
    }

    public <T> T call(RetryCallable<T> callable) throws IOException {
        int tries = 0;
        while (true) {
            try {
                T result;
                if (tries > 0) {
                    callable.update();
                }
                if (callable.isResultExpected(result = callable.call())) {
                    return result;
                }
                throw new UnExpectResultException("unexpected result:" + result.toString());
            }
            catch (Throwable t) {
                if (++tries > this.retries) {
                    throw new IOException("Fail after " + this.retries + " retries", t);
                }
                logger.info("call fail because of {}, {} retry", (Object)t.getMessage(), (Object)tries);
                this.sleep(tries);
                continue;
            }
            break;
        }
    }

    private void sleep(int retryCnt) {
        int sleepTime = this.getSleepTime(retryCnt);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ie) {
            logger.error("interrupted", ie);
        }
    }

    private int getSleepTime(int retryCnt) {
        int tries = retryCnt;
        if (retryCnt >= RETRY_BACKOFF.length) {
            tries = RETRY_BACKOFF.length - 1;
        }
        return this.pauseTimeInMs * RETRY_BACKOFF[tries];
    }

    private static class UnExpectResultException
    extends RuntimeException {
        public UnExpectResultException(String msg) {
            super(msg);
        }
    }
}

