/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataWriter;
import org.apache.kylin.stream.core.storage.columnar.GeneralColumnDataWriter;

public class LZ4CompressedColumnWriter
implements ColumnDataWriter {
    public static final int DEF_BLOCK_SIZE = 65536;
    private int valLen;
    private int numValInBlock;
    private int blockCnt;
    private LZ4Compressor compressor;
    private ByteBuffer writeBuffer;
    private DataOutputStream dataOutput;
    private GeneralColumnDataWriter blockDataWriter;

    public LZ4CompressedColumnWriter(int valLen, int rowCnt, int compressBlockSize, OutputStream output) {
        this.valLen = valLen;
        this.numValInBlock = compressBlockSize / valLen;
        this.blockCnt = rowCnt / this.numValInBlock;
        if (rowCnt % this.numValInBlock != 0) {
            ++this.blockCnt;
        }
        this.compressor = LZ4Factory.fastestInstance().highCompressor();
        this.writeBuffer = ByteBuffer.allocate(this.numValInBlock * valLen);
        this.dataOutput = new DataOutputStream(output);
        this.blockDataWriter = new GeneralColumnDataWriter(this.blockCnt, this.dataOutput);
    }

    @Override
    public void write(byte[] valBytes) throws IOException {
        if (!this.writeBuffer.hasRemaining()) {
            this.writeBuffer.rewind();
            byte[] block = this.compressor.compress(this.writeBuffer.array(), 0, this.writeBuffer.limit());
            this.blockDataWriter.write(block);
        }
        this.writeBuffer.put(valBytes);
    }

    @Override
    public void flush() throws IOException {
        if (this.writeBuffer != null) {
            this.writeBuffer.flip();
            if (this.writeBuffer.hasRemaining()) {
                byte[] block = this.compressor.compress(this.writeBuffer.array(), 0, this.writeBuffer.limit());
                this.blockDataWriter.write(block);
            }
        }
        this.blockDataWriter.flush();
        this.dataOutput.writeInt(this.numValInBlock);
        this.dataOutput.writeInt(this.valLen);
        this.dataOutput.flush();
        this.writeBuffer = null;
    }
}

