/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.exception;

import java.util.Locale;
import org.apache.kylin.stream.core.exception.StreamingException;

public class ClusterStateException
extends StreamingException {
    private final String cubeName;
    private final ClusterState clusterState;
    private final TransactionStep transactionStep;
    private final String inconsistentPart;

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public TransactionStep getTransactionStep() {
        return this.transactionStep;
    }

    public String getInconsistentPart() {
        return this.inconsistentPart;
    }

    public ClusterStateException(String cubeName, ClusterState state, TransactionStep step, String failedRs, Throwable cause) {
        super(String.format(Locale.ROOT, "Cube: %s    State: %s    Step: %s    Affect: %s", cubeName, state.name(), step.name(), failedRs), cause);
        this.cubeName = cubeName;
        this.transactionStep = step;
        this.clusterState = state;
        this.inconsistentPart = failedRs;
    }

    public static enum TransactionStep {
        STOP_AND_SNYC,
        ASSIGN_NEW,
        START_NEW,
        MAKE_IMMUTABLE;

    }

    public static enum ClusterState {
        CONSISTENT,
        ROLLBACK_SUCCESS,
        ROLLBACK_FAILED;

    }
}

