/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka;

import java.util.Map;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.source.kafka.AbstractTimeParser;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeParser
extends AbstractTimeParser {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeParser.class);
    private String tsPattern = null;
    private FastDateFormat formatter = null;

    public DateTimeParser(Map<String, String> properties) {
        super(properties);
        this.tsPattern = properties.get("tsPattern");
        try {
            this.formatter = DateFormat.getDateFormat(this.tsPattern);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Invalid tsPattern: '" + this.tsPattern + "'.");
        }
    }

    @Override
    public long parseTime(String timeStr) throws IllegalArgumentException {
        try {
            return this.formatter.parse(timeStr).getTime();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid value: pattern: '" + this.tsPattern + "', value: '" + timeStr + "'", e);
        }
    }
}

