/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.userdetails.LdapUserDetailsImpl;
import org.springframework.security.ldap.userdetails.LdapUserDetailsService;
import org.springframework.security.saml.SAMLCredential;

public class SAMLUserDetailsService
implements org.springframework.security.saml.userdetails.SAMLUserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(SAMLUserDetailsService.class);
    private LdapUserDetailsService ldapUserDetailsService;

    public SAMLUserDetailsService(LdapUserDetailsService ldapUserDetailsService) {
        this.ldapUserDetailsService = ldapUserDetailsService;
    }

    public Object loadUserBySAML(SAMLCredential samlCredential) throws UsernameNotFoundException {
        String userEmail = samlCredential.getAttributeAsString("email");
        logger.debug("samlCredential.email:" + userEmail);
        String userName = userEmail.substring(0, userEmail.indexOf("@"));
        UserDetails userDetails = null;
        try {
            userDetails = this.ldapUserDetailsService.loadUserByUsername(userName);
            if (userDetails instanceof LdapUserDetailsImpl) {
                LdapUserDetailsImpl.Essence essence = new LdapUserDetailsImpl.Essence();
                essence.setDn(((LdapUserDetailsImpl)userDetails).getDn());
                essence.setUsername(userEmail);
                essence.setPassword(userDetails.getPassword());
                essence.setAuthorities(userDetails.getAuthorities());
                essence.setTimeBeforeExpiration(((LdapUserDetailsImpl)userDetails).getTimeBeforeExpiration());
                essence.setGraceLoginsRemaining(((LdapUserDetailsImpl)userDetails).getGraceLoginsRemaining());
                userDetails = essence.createUserDetails();
            }
        }
        catch (UsernameNotFoundException e) {
            logger.error("User not found in LDAP, check whether he/she has been added to the groups.", e);
        }
        logger.debug("userDeail by search ldap with '" + userName + "' is: " + userDetails);
        return userDetails;
    }
}

