/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Properties;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class PasswordPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    public PasswordPlaceholderConfigurer() throws IOException {
        Resource[] resources = new Resource[1];
        Properties prop = this.getAllKylinProperties();
        StringWriter writer = new StringWriter();
        prop.store(new PrintWriter(writer), "kylin properties");
        String propString = writer.getBuffer().toString();
        IOUtils.closeQuietly(writer);
        InputStream is = IOUtils.toInputStream(propString, Charset.defaultCharset());
        resources[0] = new InputStreamResource(is);
        this.setLocations(resources);
    }

    public Properties getAllKylinProperties() {
        Properties allProps = null;
        try {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            Method getAllMethod = KylinConfigBase.class.getDeclaredMethod("getAllProperties", new Class[0]);
            getAllMethod.setAccessible(true);
            allProps = (Properties)getAllMethod.invoke((Object)kylinConfig, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return allProps;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        if (placeholder.toLowerCase(Locale.ROOT).contains("password")) {
            return EncryptUtil.decrypt(props.getProperty(placeholder));
        }
        return props.getProperty(placeholder);
    }

    private static void printUsage() {
        System.out.println("Usage: ${KYLIN_HOME}/bin/kylin.sh org.apache.kylin.rest.security.PasswordPlaceholderConfigurer <EncryptMethod> <your_password>");
        System.out.println("EncryptMethod: AES or BCrypt");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            PasswordPlaceholderConfigurer.printUsage();
            System.exit(1);
        }
        String encryptMethod = args[0];
        String passwordTxt = args[1];
        if ("AES".equalsIgnoreCase(encryptMethod)) {
            System.out.println(encryptMethod + " encrypted password is: ");
            System.out.println(EncryptUtil.encrypt(passwordTxt));
        } else if ("BCrypt".equalsIgnoreCase(encryptMethod)) {
            BCryptPasswordEncoder bCryptPasswordEncoder = new BCryptPasswordEncoder();
            System.out.println(encryptMethod + " encrypted password is: ");
            System.out.println(bCryptPasswordEncoder.encode(passwordTxt));
        } else {
            PasswordPlaceholderConfigurer.printUsage();
            System.exit(1);
        }
    }
}

