/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.query.relnode.OLAPFilterRel;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPNonEquiJoinRel;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPJoinRule
extends ConverterRule {
    public static final ConverterRule INSTANCE = new OLAPJoinRule();

    public OLAPJoinRule() {
        super(LogicalJoin.class, (RelTrait)Convention.NONE, (RelTrait)OLAPRel.CONVENTION, "OLAPJoinRule");
    }

    public RelNode convert(RelNode rel) {
        OLAPRel newRel;
        LogicalJoin join = (LogicalJoin)rel;
        RelNode left = join.getInput(0);
        RelNode right = join.getInput(1);
        RelTraitSet traitSet = join.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION);
        JoinInfo info = JoinInfo.of((RelNode)(left = OLAPJoinRule.convert((RelNode)left, (RelTraitSet)left.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION))), (RelNode)(right = OLAPJoinRule.convert((RelNode)right, (RelTraitSet)right.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION))), (RexNode)join.getCondition());
        if (!info.isEqui() && join.getJoinType() != JoinRelType.INNER) {
            try {
                return new OLAPNonEquiJoinRel(join.getCluster(), traitSet, left, right, join.getCondition(), join.getVariablesSet(), join.getJoinType());
            }
            catch (InvalidRelException e) {
                throw new IllegalStateException(e);
            }
        }
        RelOptCluster cluster = join.getCluster();
        try {
            newRel = new OLAPJoinRel(cluster, traitSet, left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), info.leftKeys, info.rightKeys, join.getVariablesSet(), join.getJoinType());
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
        if (!info.isEqui()) {
            newRel = new OLAPFilterRel(cluster, newRel.getTraitSet(), newRel, info.getRemaining(cluster.getRexBuilder()));
        }
        return newRel;
    }
}

