/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.Serializable;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.MapReduceUtil;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.spark.KylinSparkJobListener;
import org.apache.kylin.engine.spark.SparkFunction;
import org.apache.kylin.engine.spark.SparkUtil;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkUpdateShardForOldCuboidDataStep
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(SparkUpdateShardForOldCuboidDataStep.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_INPUT_PATH;
    public static final Option OPTION_OUTPUT_PATH;
    public static final Option OPTION_META_URL;
    private Options options;
    private CubeDesc cubeDesc;
    private RowKeySplitter rowKeySplitter;
    private RowKeyEncoderProvider rowKeyEncoderProvider;
    private byte[] newKeyBodyBuf = new byte[16640];
    private ByteArray newKeyBuf = ByteArray.allocate(16640);

    public SparkUpdateShardForOldCuboidDataStep() {
        this.options = new Options();
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_INPUT_PATH);
        this.options.addOption(OPTION_OUTPUT_PATH);
        this.options.addOption(OPTION_META_URL);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        final String cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String inputPath = optionsHelper.getOptionValue(OPTION_INPUT_PATH);
        String outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH);
        final String metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        String baseCuboIdInputPath = inputPath + "base_cuboid";
        String oldCuboIdInputPath = inputPath + "old";
        SparkConf sparkConf = SparkUtil.setKryoSerializerInConf();
        sparkConf.setAppName("Update_Old_Cuboid_Shard_for_Optimization" + cubeName + "_With_Spark");
        KylinSparkJobListener jobListener = new KylinSparkJobListener();
        try (JavaSparkContext sc = new JavaSparkContext(sparkConf);){
            sc.sc().addSparkListener((SparkListenerInterface)jobListener);
            final SerializableConfiguration sConf = new SerializableConfiguration(sc.hadoopConfiguration());
            KylinConfig config = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
            HadoopUtil.deletePath(HadoopUtil.getCurrentConfiguration(), new Path(outputPath));
            CubeManager cubeManager = CubeManager.getInstance(config);
            CubeInstance cube = cubeManager.getCube(cubeName);
            final CubeSegment optSegment = cube.getSegmentById(segmentId);
            final CubeSegment originalSegment = cube.getOriginalSegmentToOptimize(optSegment);
            optSegment.setCubeInstance(originalSegment.getCubeInstance());
            JavaPairRDD baseCuboIdRDD = sc.sequenceFile(baseCuboIdInputPath, Text.class, Text.class);
            JavaPairRDD oldCuboIdRDD = sc.sequenceFile(oldCuboIdInputPath, Text.class, Text.class);
            this.cubeDesc = cube.getDescriptor();
            logger.info("start to calculate nBaseReduceTasks");
            Pair<Integer, Integer> taskNums = MapReduceUtil.getConvergeCuboidDataReduceTaskNums(originalSegment);
            int reduceTasks = taskNums.getFirst();
            int nBaseReduceTasks = taskNums.getSecond();
            logger.info("nBaseReduceTasks is {}", (Object)nBaseReduceTasks);
            Job job = Job.getInstance((Configuration)sConf.get());
            SparkUtil.setHadoopConfForCuboid(job, originalSegment, metaUrl);
            JavaPairRDD mapBaseCuboIdRDD = baseCuboIdRDD.mapToPair((PairFunction)new SparkFunction.PairFunctionBase<Tuple2<Text, Text>, Text, Text>(){

                @Override
                protected void doInit() {
                    SparkUpdateShardForOldCuboidDataStep.this.initMethod(sConf, metaUrl, cubeName, optSegment, originalSegment);
                }

                @Override
                protected Tuple2<Text, Text> doCall(Tuple2<Text, Text> tuple2) throws Exception {
                    Text outputKey = new Text();
                    long cuboidID = SparkUpdateShardForOldCuboidDataStep.this.rowKeySplitter.split(((Text)tuple2._1).getBytes());
                    Cuboid cuboid = new Cuboid(SparkUpdateShardForOldCuboidDataStep.this.cubeDesc, cuboidID, cuboidID);
                    int fullKeySize = SparkUpdateShardForOldCuboidDataStep.this.buildKey(cuboid, SparkUpdateShardForOldCuboidDataStep.this.rowKeySplitter.getSplitBuffers());
                    outputKey.set(SparkUpdateShardForOldCuboidDataStep.this.newKeyBuf.array(), 0, fullKeySize);
                    return new Tuple2((Object)outputKey, tuple2._2);
                }
            });
            SparkUtil.configConvergeCuboidDataReduceOut(job, SparkUtil.generateFilePath("base_cuboid", outputPath));
            mapBaseCuboIdRDD.repartition(nBaseReduceTasks).saveAsNewAPIHadoopDataset(job.getConfiguration());
            JavaPairRDD mapOldCuboIdRDD = oldCuboIdRDD.mapToPair((PairFunction)new SparkFunction.PairFunctionBase<Tuple2<Text, Text>, Text, Text>(){

                @Override
                protected void doInit() {
                    SparkUpdateShardForOldCuboidDataStep.this.initMethod(sConf, metaUrl, cubeName, optSegment, originalSegment);
                }

                @Override
                protected Tuple2<Text, Text> doCall(Tuple2<Text, Text> tuple2) throws Exception {
                    Text outputKey = new Text();
                    long cuboidID = SparkUpdateShardForOldCuboidDataStep.this.rowKeySplitter.split(((Text)tuple2._1).getBytes());
                    Cuboid cuboid = new Cuboid(SparkUpdateShardForOldCuboidDataStep.this.cubeDesc, cuboidID, cuboidID);
                    int fullKeySize = SparkUpdateShardForOldCuboidDataStep.this.buildKey(cuboid, SparkUpdateShardForOldCuboidDataStep.this.rowKeySplitter.getSplitBuffers());
                    outputKey.set(SparkUpdateShardForOldCuboidDataStep.this.newKeyBuf.array(), 0, fullKeySize);
                    return new Tuple2((Object)outputKey, tuple2._2);
                }
            });
            SparkUtil.configConvergeCuboidDataReduceOut(job, SparkUtil.generateFilePath("old", outputPath));
            mapOldCuboIdRDD.repartition(reduceTasks).saveAsNewAPIHadoopDataset(job.getConfiguration());
        }
    }

    private int buildKey(Cuboid cuboid, ByteArray[] splitBuffers) {
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(cuboid);
        int startIdx = this.rowKeySplitter.getBodySplitOffset();
        int endIdx = startIdx + Long.bitCount(cuboid.getId());
        int offset = 0;
        for (int i = startIdx; i < endIdx; ++i) {
            System.arraycopy(splitBuffers[i].array(), splitBuffers[i].offset(), this.newKeyBodyBuf, offset, splitBuffers[i].length());
            offset += splitBuffers[i].length();
        }
        int fullKeySize = rowkeyEncoder.getBytesLength();
        while (this.newKeyBuf.array().length < fullKeySize) {
            this.newKeyBuf = new ByteArray(this.newKeyBuf.length() * 2);
        }
        this.newKeyBuf.setLength(fullKeySize);
        rowkeyEncoder.encode(new ByteArray(this.newKeyBodyBuf, 0, offset), this.newKeyBuf);
        return fullKeySize;
    }

    private void initMethod(SerializableConfiguration sConf, String metaUrl, String cubeName, CubeSegment optSegment, CubeSegment originalSegment) {
        KylinConfig kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, metaUrl);
        KylinConfig.setKylinConfigInEnvIfMissing(kylinConfig.exportToProperties());
        CubeInstance cubeInstance = CubeManager.getInstance(kylinConfig).getCube(cubeName);
        CubeSegment originalSeg = cubeInstance.getSegmentById(originalSegment.getUuid());
        CubeSegment optSeg = cubeInstance.getSegmentById(optSegment.getUuid());
        this.rowKeySplitter = new RowKeySplitter(originalSeg);
        this.rowKeyEncoderProvider = new RowKeyEncoderProvider(optSeg);
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"segmentId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
    }
}

