/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.common;

import java.io.Serializable;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class RowKeySplitter
implements Serializable {
    private CubeDesc cubeDesc;
    private RowKeyColumnIO colIO;
    private ByteArray[] splitBuffers;
    private int[] splitOffsets;
    private int bufferSize;
    private boolean enableSharding;
    private short shardId;

    public ByteArray[] getSplitBuffers() {
        return this.splitBuffers;
    }

    public int[] getSplitOffsets() {
        return this.splitOffsets;
    }

    public int getBodySplitOffset() {
        if (this.enableSharding) {
            return 2;
        }
        return 1;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public RowKeySplitter(CubeSegment cubeSeg) {
        this(cubeSeg, cubeSeg.getCubeDesc().getRowkey().getRowKeyColumns().length + 2, cubeSeg.getConfig().getDimensionEncodingMaxLength());
    }

    public RowKeySplitter(CubeSegment cubeSeg, int splitLen, int bytesLen) {
        this.enableSharding = cubeSeg.isEnableSharding();
        this.cubeDesc = cubeSeg.getCubeDesc();
        CubeDimEncMap dimEncoding = new CubeDimEncMap(cubeSeg);
        for (RowKeyColDesc rowKeyColDesc : this.cubeDesc.getRowkey().getRowKeyColumns()) {
            dimEncoding.get(rowKeyColDesc.getColRef());
        }
        this.colIO = new RowKeyColumnIO(dimEncoding);
        this.splitBuffers = new ByteArray[splitLen];
        this.splitOffsets = new int[splitLen];
        this.bufferSize = 0;
    }

    public Short getShardId() {
        if (this.enableSharding) {
            return this.shardId;
        }
        return null;
    }

    public long parseCuboid(byte[] bytes) {
        return RowKeySplitter.getCuboidId(bytes, this.enableSharding);
    }

    public static long getCuboidId(byte[] bytes, boolean enableSharding) {
        int offset = enableSharding ? 2 : 0;
        return Bytes.toLong(bytes, offset, 8);
    }

    public long split(byte[] bytes) {
        this.bufferSize = 0;
        int offset = 0;
        if (this.enableSharding) {
            ByteArray shardSplit = new ByteArray(bytes, offset, 2);
            this.splitBuffers[this.bufferSize++] = shardSplit;
            offset += 2;
            this.shardId = Bytes.toShort(shardSplit.array(), shardSplit.offset());
        }
        ByteArray cuboidIdSplit = new ByteArray(bytes, offset, 8);
        this.splitBuffers[this.bufferSize++] = cuboidIdSplit;
        offset += 8;
        long lastSplittedCuboidId = Bytes.toLong(cuboidIdSplit.array(), cuboidIdSplit.offset(), 8);
        Cuboid cuboid = Cuboid.findForMandatory(this.cubeDesc, lastSplittedCuboidId);
        for (int i = 0; i < cuboid.getColumns().size(); ++i) {
            this.splitOffsets[i] = offset;
            TblColRef col = cuboid.getColumns().get(i);
            int colLength = this.colIO.getColumnLength(col);
            ByteArray split = new ByteArray(bytes, offset, colLength);
            this.splitBuffers[this.bufferSize++] = split;
            offset += colLength;
        }
        return lastSplittedCuboidId;
    }
}

