/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.debug;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class BackdoorToggles {
    private static final InternalThreadLocal<Map<String, String>> _backdoorToggles = new InternalThreadLocal();
    public static final String DEBUG_TOGGLE_DISABLE_FUZZY_KEY = "DEBUG_TOGGLE_DISABLE_FUZZY_KEY";
    public static final String DEBUG_TOGGLE_DISABLE_QUERY_CACHE = "DEBUG_TOGGLE_DISABLE_QUERY_CACHE";
    public static final String DEBUG_TOGGLE_DISABLE_QUERY_SEGMENT_CACHE = "DEBUG_TOGGLE_DISABLE_QUERY_SEGMENT_CACHE";
    public static final String DEBUG_TOGGLE_HBASE_CUBE_QUERY_VERSION = "DEBUG_TOGGLE_HBASE_CUBE_QUERY_VERSION";
    public static final String DEBUG_TOGGLE_HBASE_CUBE_QUERY_PROTOCOL = "DEBUG_TOGGLE_HBASE_CUBE_QUERY_PROTOCOL";
    public static final String DEBUG_TOGGLE_COPROCESSOR_BEHAVIOR = "DEBUG_TOGGLE_COPROCESSOR_BEHAVIOR";
    public static final String DEBUG_TOGGLE_LOCAL_COPROCESSOR = "DEBUG_TOGGLE_LOCAL_COPROCESSOR";
    public static final String DEBUG_TOGGLE_QUERY_TIMEOUT = "DEBUG_TOGGLE_QUERY_TIMEOUT";
    public static final String DEBUG_TOGGLE_SHARD_ASSIGNMENT = "DEBUG_TOGGLE_SHARD_ASSIGNMENT";
    public static final String DEBUG_TOGGLE_PARTITION_DUMP_DIR = "DEBUG_TOGGLE_PARTITION_DUMP_DIR";
    public static final String DEBUG_TOGGLE_DUMPED_PARTITION_DIR = "DEBUG_TOGGLE_DUMPED_PARTITION_DIR";
    public static final String DEBUG_TOGGLE_PREPARE_ONLY = "DEBUG_TOGGLE_PREPARE_ONLY";
    public static final String ATTR_STATEMENT_MAX_ROWS = "ATTR_STATEMENT_MAX_ROWS";
    public static final String DEBUG_TOGGLE_CHECK_ALL_MODELS = "DEBUG_TOGGLE_CHECK_ALL_MODELS";
    public static final String DISABLE_RAW_QUERY_HACKER = "DISABLE_RAW_QUERY_HACKER";
    public static final String DEBUG_TOGGLE_HTRACE_ENABLED = "DEBUG_TOGGLE_HTRACE_ENABLED";
    public static final String JDBC_CLIENT_CALCITE_PROPS = "JDBC_CLIENT_CALCITE_PROPS";
    public static final String DEBUG_TOGGLE_STREAMING_DETAIL_PROFILE = "DEBUG_TOGGLE_STREAMING_DETAIL_PROFILE";
    public static final String DEBUG_TOGGLE_HIT_CUBE = "DEBUG_TOGGLE_HIT_CUBE";

    public static void setToggles(Map<String, String> toggles) {
        _backdoorToggles.set(toggles);
    }

    public static void addToggle(String key, String value) {
        Map<String, String> map = _backdoorToggles.get();
        if (map == null) {
            BackdoorToggles.setToggles(Maps.newHashMap());
        }
        _backdoorToggles.get().put(key, value);
    }

    public static void addToggles(Map<String, String> toggles) {
        Map<String, String> map = _backdoorToggles.get();
        if (map == null) {
            BackdoorToggles.setToggles(Maps.newHashMap());
        }
        _backdoorToggles.get().putAll(toggles);
    }

    public static String getToggle(String key) {
        Map<String, String> map = _backdoorToggles.get();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static String getForceHitCube() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_HIT_CUBE);
    }

    public static String getCoprocessorBehavior() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_COPROCESSOR_BEHAVIOR);
    }

    public static String getHbaseCubeQueryVersion() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_HBASE_CUBE_QUERY_VERSION);
    }

    public static String getHbaseCubeQueryProtocol() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_HBASE_CUBE_QUERY_PROTOCOL);
    }

    public static boolean getDisableCache() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_DISABLE_QUERY_CACHE);
    }

    public static boolean getDisableSegmentCache() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_DISABLE_QUERY_SEGMENT_CACHE);
    }

    public static boolean getDisableFuzzyKey() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_DISABLE_FUZZY_KEY);
    }

    public static boolean getRunLocalCoprocessor() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_LOCAL_COPROCESSOR);
    }

    public static String getPartitionDumpDir() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_PARTITION_DUMP_DIR);
    }

    public static String getDumpedPartitionDir() {
        return BackdoorToggles.getString(DEBUG_TOGGLE_DUMPED_PARTITION_DIR);
    }

    public static boolean getCheckAllModels() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_CHECK_ALL_MODELS);
    }

    public static boolean getDisabledRawQueryLastHacker() {
        return BackdoorToggles.getBoolean(DISABLE_RAW_QUERY_HACKER);
    }

    public static boolean getHtraceEnabled() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_HTRACE_ENABLED);
    }

    public static boolean isStreamingProfileEnable() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_STREAMING_DETAIL_PROFILE);
    }

    public static int getQueryTimeout() {
        String v = BackdoorToggles.getString(DEBUG_TOGGLE_QUERY_TIMEOUT);
        if (v == null) {
            return -1;
        }
        return Integer.parseInt(v);
    }

    public static Pair<Short, Short> getShardAssignment() {
        String v = BackdoorToggles.getString(DEBUG_TOGGLE_SHARD_ASSIGNMENT);
        if (v == null) {
            return null;
        }
        String[] parts = StringUtils.split(v, "#");
        return Pair.newPair(Short.valueOf(parts[0]), Short.valueOf(parts[1]));
    }

    public static Integer getStatementMaxRows() {
        String v = BackdoorToggles.getString(ATTR_STATEMENT_MAX_ROWS);
        if (v == null) {
            return null;
        }
        return Integer.valueOf(v);
    }

    public static boolean getPrepareOnly() {
        return BackdoorToggles.getBoolean(DEBUG_TOGGLE_PREPARE_ONLY);
    }

    private static String getString(String key) {
        Map<String, String> toggles = _backdoorToggles.get();
        if (toggles == null) {
            return null;
        }
        return toggles.get(key);
    }

    private static boolean getBoolean(String key) {
        return "true".equals(BackdoorToggles.getString(key));
    }

    public static void cleanToggles() {
        _backdoorToggles.remove();
    }

    public static Properties getJdbcDriverClientCalciteProps() {
        Properties props = new Properties();
        String propsStr = BackdoorToggles.getString(JDBC_CLIENT_CALCITE_PROPS);
        if (propsStr == null) {
            return props;
        }
        try {
            props.load(new StringReader(propsStr));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashSet<String> allowedPropsNames = Sets.newHashSet("caseSensitive", "unquotedCasing", "quoting", "conformance");
        for (String key : props.stringPropertyNames()) {
            if (allowedPropsNames.contains(key)) continue;
            props.remove(key);
        }
        return props;
    }
}

