/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.core.NestedRuntimeException;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.test.web.servlet.DispatcherServletCustomizer;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.TestDispatcherServlet;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public abstract class MockMvcBuilderSupport {
    @Deprecated
    protected final MockMvc createMockMvc(Filter[] filters, MockServletConfig servletConfig, WebApplicationContext webAppContext, RequestBuilder defaultRequestBuilder, List<ResultMatcher> globalResultMatchers, List<ResultHandler> globalResultHandlers, Boolean dispatchOptions) {
        return this.createMockMvc(filters, servletConfig, webAppContext, defaultRequestBuilder, globalResultMatchers, globalResultHandlers, Collections.singletonList(new DispatchOptionsDispatcherServletCustomizer(dispatchOptions)));
    }

    protected final MockMvc createMockMvc(Filter[] filters, MockServletConfig servletConfig, WebApplicationContext webAppContext, RequestBuilder defaultRequestBuilder, List<ResultMatcher> globalResultMatchers, List<ResultHandler> globalResultHandlers, List<DispatcherServletCustomizer> dispatcherServletCustomizers) {
        ServletContext servletContext = webAppContext.getServletContext();
        TestDispatcherServlet dispatcherServlet = new TestDispatcherServlet(webAppContext);
        if (dispatcherServletCustomizers != null) {
            for (DispatcherServletCustomizer customizers : dispatcherServletCustomizers) {
                customizers.customize(dispatcherServlet);
            }
        }
        try {
            dispatcherServlet.init(servletConfig);
        }
        catch (ServletException ex) {
            throw new MockMvcBuildException("Failed to initialize TestDispatcherServlet", ex);
        }
        MockMvc mockMvc = new MockMvc(dispatcherServlet, filters, servletContext);
        mockMvc.setDefaultRequest(defaultRequestBuilder);
        mockMvc.setGlobalResultMatchers(globalResultMatchers);
        mockMvc.setGlobalResultHandlers(globalResultHandlers);
        return mockMvc;
    }

    private static class DispatchOptionsDispatcherServletCustomizer
    implements DispatcherServletCustomizer {
        private final Boolean dispatchOptions;

        private DispatchOptionsDispatcherServletCustomizer(Boolean dispatchOptions) {
            this.dispatchOptions = dispatchOptions;
        }

        @Override
        public void customize(DispatcherServlet dispatcherServlet) {
            dispatcherServlet.setDispatchOptionsRequest(this.dispatchOptions);
        }
    }

    private static class MockMvcBuildException
    extends NestedRuntimeException {
        public MockMvcBuildException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

