/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.invertindex;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.apache.kylin.stream.core.storage.columnar.invertindex.ColInvertIndexWriter;

public class SeqColInvertIndexWriter
extends ColInvertIndexWriter {
    private int minColVal;
    private int maxColVal;
    private MutableRoaringBitmap[] valueBitmaps;
    private MutableRoaringBitmap nullValueBitmap;
    private int rows;

    public SeqColInvertIndexWriter(String columnName, int minColVal, int maxColVal) {
        super(columnName);
        this.minColVal = minColVal;
        this.maxColVal = maxColVal;
        this.valueBitmaps = new MutableRoaringBitmap[maxColVal - minColVal + 1];
    }

    @Override
    public void addValue(byte[] value) {
        if (value == null || DimensionEncoding.isNull(value, 0, value.length)) {
            if (this.nullValueBitmap == null) {
                this.nullValueBitmap = new MutableRoaringBitmap();
            }
            this.nullValueBitmap.add(++this.rows);
        } else {
            int intVal = Bytes.readAsInt(value, 0, value.length);
            if (intVal < this.minColVal || intVal > this.maxColVal) {
                throw new IllegalArgumentException("the value:" + intVal + " is not in (" + this.minColVal + "," + this.maxColVal + ")");
            }
            int idx = intVal - this.minColVal;
            MutableRoaringBitmap bitmap = this.valueBitmaps[idx];
            if (bitmap == null) {
                this.valueBitmaps[idx] = bitmap = new MutableRoaringBitmap();
            }
            bitmap.add(++this.rows);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        int cardinality = this.valueBitmaps.length;
        if (this.nullValueBitmap != null) {
            ++cardinality;
        }
        int dictionaryPartLen = cardinality * 4;
        DataOutputStream bitmapOut = new DataOutputStream(out);
        int footAndDictLen = 17 + dictionaryPartLen;
        ByteBuffer footBuffer = ByteBuffer.allocate(footAndDictLen);
        int offset = 0;
        for (MutableRoaringBitmap bitmap : this.valueBitmaps) {
            bitmap.runOptimize();
            int bitmapSize = bitmap.serializedSizeInBytes();
            bitmap.serialize(bitmapOut);
            footBuffer.putInt(offset);
            offset += bitmapSize;
        }
        if (this.nullValueBitmap != null) {
            this.nullValueBitmap.serialize(bitmapOut);
            footBuffer.putInt(offset);
        }
        footBuffer.putInt(cardinality);
        footBuffer.putInt(this.minColVal);
        footBuffer.putInt(this.maxColVal);
        footBuffer.putInt(0);
        if (this.nullValueBitmap != null) {
            footBuffer.put((byte)1);
        } else {
            footBuffer.put((byte)0);
        }
        out.write(footBuffer.array(), 0, footBuffer.position());
        out.flush();
    }
}

