/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.stream.core.query.IStreamingGTSearcher;
import org.apache.kylin.stream.core.query.ResultCollector;
import org.apache.kylin.stream.core.query.StreamingDataQueryPlanner;
import org.apache.kylin.stream.core.query.StreamingQueryProfile;
import org.apache.kylin.stream.core.query.StreamingSearchContext;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreCache;
import org.apache.kylin.stream.core.storage.columnar.DataSegmentFragment;
import org.apache.kylin.stream.core.storage.columnar.FragmentData;
import org.apache.kylin.stream.core.storage.columnar.FragmentFileSearcher;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarSegmentStoreFilesSearcher
implements IStreamingGTSearcher {
    private static Logger logger = LoggerFactory.getLogger(ColumnarSegmentStoreFilesSearcher.class);
    private String segmentName;
    private List<DataSegmentFragment> fragments;
    private StreamingQueryProfile queryProfile;

    public ColumnarSegmentStoreFilesSearcher(String segmentName, List<DataSegmentFragment> fragments) {
        this.segmentName = segmentName;
        this.fragments = fragments;
        this.queryProfile = StreamingQueryProfile.get();
    }

    @Override
    public void search(StreamingSearchContext searchContext, ResultCollector collector) throws IOException {
        logger.info("query-{}: scan segment {}, fragment files num:{}", this.queryProfile.getQueryId(), this.segmentName, this.fragments.size());
        for (DataSegmentFragment fragment : this.fragments) {
            File metaFile = fragment.getMetaFile();
            if (!metaFile.exists()) {
                if (!this.queryProfile.isDetailProfileEnable()) continue;
                logger.info("query-{}: for segment {} skip fragment {}, no meta file exists", this.queryProfile.getQueryId(), this.segmentName, fragment.getFragmentId());
                continue;
            }
            FragmentData fragmentData = this.loadFragmentData(fragment);
            FragmentMetaInfo fragmentMetaInfo = fragmentData.getFragmentMetaInfo();
            StreamingDataQueryPlanner queryPlanner = searchContext.getQueryPlanner();
            if (fragmentMetaInfo.hasValidEventTimeRange() && queryPlanner.canSkip(fragmentMetaInfo.getMinEventTime(), fragmentMetaInfo.getMaxEventTime(), true)) continue;
            this.queryProfile.incScanFile(fragmentData.getSize());
            FragmentFileSearcher fragmentFileSearcher = new FragmentFileSearcher(fragment, fragmentData);
            fragmentFileSearcher.search(searchContext, collector);
        }
        collector.addCloseListener(new ResultCollector.CloseListener(){

            @Override
            public void onClose() {
                for (DataSegmentFragment fragment : ColumnarSegmentStoreFilesSearcher.this.fragments) {
                    ColumnarStoreCache.getInstance().finishReadFragmentData(fragment);
                }
            }
        });
    }

    private FragmentData loadFragmentData(DataSegmentFragment fragment) throws IOException {
        if (this.queryProfile.isDetailProfileEnable()) {
            this.queryProfile.startStep(this.getLoadFragmentDataStep(fragment));
        }
        FragmentData fragmentData = ColumnarStoreCache.getInstance().startReadFragmentData(fragment);
        if (this.queryProfile.isDetailProfileEnable()) {
            this.queryProfile.finishStep(this.getLoadFragmentDataStep(fragment));
        }
        return fragmentData;
    }

    private String getLoadFragmentDataStep(DataSegmentFragment fragment) {
        return String.format(Locale.ROOT, "segment-%s_fragment-%s_load_data", this.segmentName, fragment.getFragmentId());
    }
}

