/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.lookup.HBaseLookupRowEncoder;

public class LookupTableToHFileMapper<KEYIN>
extends KylinMapper<KEYIN, Object, ImmutableBytesWritable, KeyValue> {
    ImmutableBytesWritable outputKey = new ImmutableBytesWritable();
    private String cubeName;
    private CubeDesc cubeDesc;
    private String tableName;
    private int shardNum;
    private IMRInput.IMRTableInputFormat lookupTableInputFormat;
    private long timestamp = 0L;
    private HBaseLookupRowEncoder encoder;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name");
        this.tableName = context.getConfiguration().get("table.name");
        this.shardNum = Integer.parseInt(context.getConfiguration().get("shard.num"));
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeManager cubeMgr = CubeManager.getInstance(config);
        this.cubeDesc = cubeMgr.getCube(this.cubeName).getDescriptor();
        DataModelDesc modelDesc = this.cubeDesc.getModel();
        TableDesc tableDesc = TableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv()).getTableDesc(this.tableName, this.cubeDesc.getProject());
        TableRef lookupTableRef = null;
        for (TableRef tableRef : modelDesc.getLookupTables()) {
            if (!tableRef.getTableIdentity().equalsIgnoreCase(this.tableName)) continue;
            lookupTableRef = tableRef;
            break;
        }
        JoinDesc joinDesc = modelDesc.getJoinByPKSide(lookupTableRef);
        TblColRef[] keyColRefs = joinDesc.getPrimaryKeyColumns();
        String[] keyColumns = new String[keyColRefs.length];
        for (int i = 0; i < keyColRefs.length; ++i) {
            keyColumns[i] = keyColRefs[i].getName();
        }
        this.encoder = new HBaseLookupRowEncoder(tableDesc, keyColumns, this.shardNum);
        Configuration conf = context.getConfiguration();
        this.lookupTableInputFormat = MRUtil.getTableInputFormat(tableDesc, conf.get("cubingJobId"));
    }

    @Override
    public void doMap(KEYIN key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        Collection<String[]> rowCollection = this.lookupTableInputFormat.parseMapperInput(value);
        for (String[] row : rowCollection) {
            HBaseLookupRowEncoder.HBaseRow hBaseRow = this.encoder.encode(row);
            byte[] rowKey = hBaseRow.getRowKey();
            NavigableMap<byte[], byte[]> qualifierValMap = hBaseRow.getQualifierValMap();
            this.outputKey.set(rowKey);
            for (Map.Entry qualifierValEntry : qualifierValMap.entrySet()) {
                KeyValue outputValue = this.createKeyValue(rowKey, (byte[])qualifierValEntry.getKey(), (byte[])qualifierValEntry.getValue());
                context.write((Object)this.outputKey, (Object)outputValue);
            }
        }
    }

    private KeyValue createKeyValue(byte[] keyBytes, byte[] qualifier, byte[] value) {
        return new KeyValue(keyBytes, 0, keyBytes.length, HBaseLookupRowEncoder.CF, 0, HBaseLookupRowEncoder.CF.length, qualifier, 0, qualifier.length, this.timestamp, KeyValue.Type.Put, value, 0, value.length);
    }
}

