/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kylin.common.util.ByteBufferBackedInputStream;
import org.apache.kylin.common.util.StreamingMessageRow;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.type.MapType;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.type.SimpleType;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Charsets;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.kafka.AbstractTimeParser;
import org.apache.kylin.source.kafka.StreamingParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimedJsonStreamParser
extends StreamingParser {
    private static final Logger logger = LoggerFactory.getLogger(TimedJsonStreamParser.class);
    private List<TblColRef> allColumns;
    private final ObjectMapper mapper;
    private String tsColName = null;
    private String tsParser = null;
    private String separator = null;
    private boolean strictCheck = true;
    private final Map<String, Object> root = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Object> tempMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> colLowerCaseMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String[]> nameMap = new HashMap<String, String[]>();
    public static final String EMBEDDED_PROPERTY_SEPARATOR = "|";
    private final JavaType mapType = MapType.construct(HashMap.class, SimpleType.construct(String.class), SimpleType.construct(Object.class));
    private AbstractTimeParser streamTimeParser;
    private long vcounter = 0L;

    public TimedJsonStreamParser(List<TblColRef> allColumns, Map<String, String> properties) {
        this.allColumns = allColumns;
        if (properties == null) {
            properties = StreamingParser.defaultProperties;
        }
        this.tsColName = properties.get("tsColName");
        this.tsParser = properties.get("tsParser");
        this.separator = properties.get("separator");
        this.strictCheck = Boolean.parseBoolean(properties.get("strictCheck"));
        if (!StringUtils.isEmpty(this.tsParser)) {
            try {
                Class<?> clazz = Class.forName(this.tsParser);
                Constructor<?> constructor = clazz.getConstructor(Map.class);
                this.streamTimeParser = (AbstractTimeParser)constructor.newInstance(properties);
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid StreamingConfig, tsParser " + this.tsParser + ", parserProperties " + properties + ".", e);
            }
        } else {
            throw new IllegalStateException("Invalid StreamingConfig, tsParser " + this.tsParser + ", parserProperties " + properties + ".");
        }
        this.mapper = new ObjectMapper();
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        this.mapper.enable(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY);
        for (TblColRef col : allColumns) {
            this.colLowerCaseMap.put(col.getName(), col.getName().toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public List<StreamingMessageRow> parse(ByteBuffer buffer) {
        try {
            Map message = (Map)this.mapper.readValue((InputStream)new ByteBufferBackedInputStream(buffer), this.mapType);
            this.root.clear();
            this.root.putAll(message);
            String tsStr = TimedJsonStreamParser.objToString(this.root.get(this.tsColName));
            long t = this.streamTimeParser.parseTime(tsStr);
            ArrayList<String> result = Lists.newArrayList();
            for (TblColRef column : this.allColumns) {
                String columnName = this.colLowerCaseMap.get(column.getName());
                if (TimedJsonStreamParser.populateDerivedTimeColumns(columnName, result, t)) continue;
                result.add(this.getValueByKey(column, this.root));
            }
            StreamingMessageRow streamingMessageRow = new StreamingMessageRow(result, 0L, t, Collections.emptyMap());
            ArrayList<StreamingMessageRow> messageRowList = new ArrayList<StreamingMessageRow>();
            messageRowList.add(streamingMessageRow);
            return messageRowList;
        }
        catch (IOException e) {
            logger.error("malformed data: {}", (Object)new String(buffer.array(), Charsets.UTF_8));
            logger.error("error", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean filter(StreamingMessageRow streamingMessageRow) {
        return true;
    }

    public String[] getEmbeddedPropertyNames(TblColRef column) {
        String colName = column.getName().toLowerCase(Locale.ROOT);
        String[] names = this.nameMap.get(colName);
        if (names == null) {
            String comment = column.getColumnDesc().getComment();
            if (!StringUtils.isEmpty(comment) && comment.contains(EMBEDDED_PROPERTY_SEPARATOR)) {
                names = comment.toLowerCase(Locale.ROOT).split("\\|");
                this.nameMap.put(colName, names);
            } else if (colName.contains(this.separator)) {
                names = colName.toLowerCase(Locale.ROOT).split(this.separator);
                this.nameMap.put(colName, names);
            }
        }
        return names;
    }

    protected String getValueByKey(TblColRef column, Map<String, Object> rootMap) throws IOException {
        String key = column.getName().toLowerCase(Locale.ROOT);
        if (rootMap.containsKey(key)) {
            return TimedJsonStreamParser.objToString(rootMap.get(key));
        }
        String[] names = this.getEmbeddedPropertyNames(column);
        if (names != null && names.length > 0) {
            this.tempMap.clear();
            this.tempMap.putAll(rootMap);
            for (int i = 0; i < names.length - 1; ++i) {
                Object o = this.tempMap.get(names[i]);
                if (o instanceof Map) {
                    this.tempMap.clear();
                    this.tempMap.putAll((Map)o);
                    continue;
                }
                if (!this.strictCheck && this.vcounter++ % 100L != 0L) continue;
                String msg = "Property '" + names[i] + "' value is not embedded JSON format. ";
                logger.warn(msg);
                if (!this.strictCheck) continue;
                throw new IOException(msg);
            }
            Object finalObject = this.tempMap.get(names[names.length - 1]);
            return TimedJsonStreamParser.objToString(finalObject);
        }
        return "";
    }

    public static String objToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            return String.valueOf(Arrays.asList((Object[])value));
        }
        return String.valueOf(value);
    }
}

