/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive.cardinality;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveColumnCardinalityUpdateJob
extends AbstractHadoopJob {
    private static final Logger logger = LoggerFactory.getLogger(HiveColumnCardinalityUpdateJob.class);
    public static final String JOB_TITLE = "Kylin Hive Column Cardinality Update Job";
    protected static final Option OPTION_TABLE;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_PROJECT);
            options.addOption(OPTION_TABLE);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            String project = this.getOptionValue(OPTION_PROJECT);
            String table = this.getOptionValue(OPTION_TABLE).toUpperCase(Locale.ROOT);
            String jobName = JOB_TITLE + this.getOptionsAsString();
            logger.info("Starting: " + jobName);
            Configuration conf = this.getConf();
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            this.updateKylinTableExd(table.toUpperCase(Locale.ROOT), output.toString(), conf, project);
            return 0;
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }

    public void updateKylinTableExd(String tableName, String outPath, Configuration config, String prj) throws IOException {
        TableMetadataManager metaMgr;
        List<String> columns = null;
        try {
            columns = HiveColumnCardinalityUpdateJob.readLines(new Path(outPath), config);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Failed to resolve cardinality for " + tableName + " from " + outPath);
            return;
        }
        StringBuffer cardi = new StringBuffer();
        for (String string : columns) {
            String[] ss = StringUtils.split((String)string, (String)"\t");
            if (ss.length != 2) {
                logger.info("The hadoop cardinality value is not valid " + string);
                continue;
            }
            cardi.append(ss[1]);
            cardi.append(",");
        }
        String scardi = cardi.toString();
        if (scardi.length() > 0) {
            scardi = scardi.substring(0, scardi.length() - 1);
            metaMgr = TableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv());
            TableExtDesc tableExt = metaMgr.getTableExt(tableName, prj);
            tableExt.setCardinality(scardi);
            metaMgr.saveTableExt(tableExt, prj);
        } else {
            metaMgr = TableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv());
            TableExtDesc tableExt = metaMgr.getTableExt(tableName, prj);
            tableExt.resetCardinality();
            metaMgr.saveTableExt(tableExt, prj);
        }
    }

    private static List<String> readLines(Path location, Configuration conf) throws Exception {
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        FileStatus[] items = fileSystem.listStatus(location);
        if (items == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (FileStatus item : items) {
            if (item.getPath().getName().startsWith("_")) continue;
            CompressionCodec codec = factory.getCodec(item.getPath());
            Object stream = null;
            stream = codec != null ? codec.createInputStream((InputStream)fileSystem.open(item.getPath())) : fileSystem.open(item.getPath());
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)stream, (Writer)writer, (String)"UTF-8");
            String raw = writer.toString();
            for (String str : StringUtil.split(raw, "\n")) {
                results.add(str);
            }
        }
        return results;
    }

    static {
        OptionBuilder.withArgName((String)"table name");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"The hive table name");
        OPTION_TABLE = OptionBuilder.create((String)"table");
    }
}

