/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.def;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.primitives.Ints;

public class TypeDef {
    private static final Pattern P = Pattern.compile("\\s*([^\\(\\)]+)\\s*(?:\\(\\s*([^\\s,]+)(?:\\s*,\\s*([^\\s,]+)\\s*)?\\))?\\s*");
    @JacksonXmlProperty(localName="ID", isAttribute=true)
    private String id;
    @JacksonXmlProperty(localName="EXPRESSION", isAttribute=true)
    private String expression;
    @JacksonXmlProperty(localName="MAXPRECISION", isAttribute=true)
    private String maxPrecision;
    private String name;
    private int defaultPrecision;
    private int defaultScale;

    void init() {
        this.id = this.id.toUpperCase(Locale.ROOT);
        Matcher m = P.matcher(this.expression);
        if (m.matches()) {
            this.name = m.group(1).toUpperCase(Locale.ROOT);
            Integer p = m.group(2) != null ? Ints.tryParse(m.group(2)) : null;
            Integer s = m.group(3) != null ? Ints.tryParse(m.group(3)) : null;
            this.defaultPrecision = p != null ? p : -1;
            this.defaultScale = s != null ? s : -1;
        }
    }

    @VisibleForTesting
    void setExpression(String expression) {
        this.expression = expression;
    }

    @VisibleForTesting
    void setId(String id) {
        this.id = id;
    }

    TypeDef() {
    }

    public String getId() {
        return this.id;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getMaxPrecision() {
        try {
            return Integer.parseInt(this.maxPrecision);
        }
        catch (Exception e) {
            return Integer.MAX_VALUE;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public String buildString(int p, int s) {
        return this.expression.replaceAll("\\$p", Integer.toString(p)).replaceAll("\\$s", Integer.toString(s));
    }

    public static TypeDef fromString(String kylinTypeName) {
        TypeDef t = new TypeDef();
        t.setId("UNKNOWN");
        t.setExpression(kylinTypeName);
        t.init();
        return t;
    }
}

