/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.kylin.common.util.MailTemplateProvider;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.shaded.com.google.common.base.Joiner;

public class MailNotificationUtil {
    public static final String JOB_ERROR = "JOB_ERROR";
    public static final String JOB_DISCARD = "JOB_DISCARD";
    public static final String JOB_SUCCEED = "JOB_SUCCEED";
    public static final String METADATA_PERSIST_FAIL = "METADATA_PERSIST_FAIL";
    public static final String NA = "NA";
    private static String localHostName;

    private MailNotificationUtil() {
        throw new IllegalStateException("Class MailNotificationUtil is an utility class !");
    }

    private static String getMailTemplateKey(ExecutableState state) {
        switch (state) {
            case ERROR: {
                return JOB_ERROR;
            }
            case DISCARDED: {
                return JOB_DISCARD;
            }
            case SUCCEED: {
                return JOB_SUCCEED;
            }
        }
        return null;
    }

    public static String getLocalHostName() {
        return localHostName;
    }

    public static String getMailContent(ExecutableState state, Map<String, Object> dataMap) {
        return MailTemplateProvider.getInstance().buildMailContent(MailNotificationUtil.getMailTemplateKey(state), dataMap);
    }

    public static String getMailContent(String key, Map<String, Object> dataMap) {
        return MailTemplateProvider.getInstance().buildMailContent(key, dataMap);
    }

    public static String getMailTitle(String ... titleParts) {
        return "[" + Joiner.on("]-[").join(titleParts) + "]";
    }

    public static boolean hasMailNotification(ExecutableState state) {
        return MailNotificationUtil.getMailTemplateKey(state) != null;
    }

    static {
        try {
            localHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            localHostName = "UNKNOWN";
        }
    }
}

