/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.roaringbitmap.buffer;

import org.apache.kylin.job.shaded.org.roaringbitmap.ShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.BufferUtil;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.MappeableArrayContainer;

final class RawReverseArrayContainerShortIterator
implements ShortIterator {
    int pos;
    MappeableArrayContainer parent;
    short[] content;

    RawReverseArrayContainerShortIterator(MappeableArrayContainer p) {
        this.parent = p;
        if (!p.isArrayBacked()) {
            throw new RuntimeException("internal bug");
        }
        this.content = p.content.array();
        this.pos = this.parent.cardinality - 1;
    }

    @Override
    public ShortIterator clone() {
        try {
            return (ShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public short next() {
        return this.content[this.pos--];
    }

    @Override
    public int nextAsInt() {
        return BufferUtil.toIntUnsigned(this.content[this.pos--]);
    }

    @Override
    public void remove() {
        this.parent.remove((short)(this.pos + 1));
        ++this.pos;
    }
}

