/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.util.Locale;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CuboidSchedulerUtil;
import org.apache.kylin.engine.mr.common.MapReduceUtil;
import org.apache.kylin.engine.mr.steps.InMemCuboidFromBaseCuboidMapper;
import org.apache.kylin.engine.mr.steps.InMemCuboidFromBaseCuboidReducer;
import org.apache.kylin.job.execution.ExecutableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCuboidFromBaseCuboidJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(InMemCuboidFromBaseCuboidJob.class);
    private boolean skipped = false;

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    private boolean checkSkip(String cubingJobId) {
        if (cubingJobId == null) {
            return false;
        }
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(cubingJobId);
        this.skipped = !cubingJob.isInMemCubing();
        return this.skipped;
    }

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            String ifNeedUpdateBaseCuboidShard;
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_CUBING_JOB_ID);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_CUBOID_MODE);
            options.addOption(OPTION_NEED_UPDATE_BASE_CUBOID_SHARD);
            this.parseOptions(options, args);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            String output = this.getOptionValue(OPTION_OUTPUT_PATH);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment cubeSeg = cube.getSegmentById(segmentID);
            String cubingJobId = this.getOptionValue(OPTION_CUBING_JOB_ID);
            String cuboidModeName = this.getOptionValue(OPTION_CUBOID_MODE);
            if (cuboidModeName == null) {
                cuboidModeName = CuboidModeEnum.CURRENT.toString();
            }
            if ((ifNeedUpdateBaseCuboidShard = this.getOptionValue(OPTION_NEED_UPDATE_BASE_CUBOID_SHARD)) == null) {
                ifNeedUpdateBaseCuboidShard = "false";
            }
            CuboidScheduler cuboidScheduler = CuboidSchedulerUtil.getCuboidSchedulerByMode(cubeSeg, cuboidModeName);
            if (this.checkSkip(cubingJobId)) {
                logger.info("Skip job " + this.getOptionValue(OPTION_JOB_NAME) + " for " + cubeSeg);
                int n = 0;
                return n;
            }
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            this.attachSegmentMetadataWithAll(cubeSeg, this.job.getConfiguration());
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.job.getConfiguration().set("cuboid.mode", cuboidModeName);
            this.job.getConfiguration().set("update.shard", ifNeedUpdateBaseCuboidShard);
            String input = this.getOptionValue(OPTION_INPUT_PATH);
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{new Path(input)});
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(InMemCuboidFromBaseCuboidMapper.class);
            this.job.setMapOutputKeyClass(ByteArrayWritable.class);
            this.job.setMapOutputValueClass(ByteArrayWritable.class);
            this.job.setReducerClass(InMemCuboidFromBaseCuboidReducer.class);
            this.job.setNumReduceTasks(MapReduceUtil.getInmemCubingReduceTaskNum(cubeSeg, cuboidScheduler));
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            Path outputPath = new Path(output);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)outputPath);
            HadoopUtil.deletePath(this.job.getConfiguration(), outputPath);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in CuboidJob", e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        InMemCuboidFromBaseCuboidJob job = new InMemCuboidFromBaseCuboidJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

