/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.MemoryBudgetController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinReducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Reducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private static final Logger logger = LoggerFactory.getLogger(KylinReducer.class);
    protected int reduceCounter = 0;

    protected void bindCurrentConfiguration(Configuration conf) {
        HadoopUtil.setCurrentConfiguration(conf);
    }

    protected final void setup(Reducer.Context context) throws IOException, InterruptedException {
        try {
            logger.info("Do setup, available memory: {}m", (Object)MemoryBudgetController.getSystemAvailMB());
            this.doSetup(context);
        }
        catch (IOException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error("", ex);
            throw ex;
        }
    }

    protected void doSetup(Reducer.Context context) throws IOException, InterruptedException {
    }

    public final void reduce(KEYIN key, Iterable<VALUEIN> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            if (this.reduceCounter++ % 100000 == 0) {
                logger.info("Accepting Reducer Key with ordinal: " + this.reduceCounter);
                logger.info("Do reduce, available memory: {}m", (Object)MemoryBudgetController.getSystemAvailMB());
            }
            this.doReduce(key, values, context);
        }
        catch (IOException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error("", ex);
            throw ex;
        }
    }

    protected void doReduce(KEYIN key, Iterable<VALUEIN> values, Reducer.Context context) throws IOException, InterruptedException {
        super.reduce(key, values, context);
    }

    protected final void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        try {
            logger.info("Do cleanup, available memory: {}m", (Object)MemoryBudgetController.getSystemAvailMB());
            this.doCleanup(context);
            logger.info("Total rows: " + this.reduceCounter);
        }
        catch (IOException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("", ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error("", ex);
            throw ex;
        }
    }

    protected void doCleanup(Reducer.Context context) throws IOException, InterruptedException {
    }
}

