/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiAtlasReplicationRemoteArgs;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiHBaseAddReplicationPeerInput;
import com.cloudera.api.swagger.model.ApiHBasePeerId;
import com.cloudera.api.swagger.model.ApiHBasePeerIdWithTableCFs;
import com.cloudera.api.swagger.model.ApiHBaseReplicationUpdatePeerStateArgs;
import com.cloudera.api.swagger.model.ApiHBaseSetCFsReplicationScope;
import com.cloudera.api.swagger.model.ApiHBaseTableNames;
import com.cloudera.api.swagger.model.ApiHBaseUpdateReplicationPeerState;
import com.cloudera.api.swagger.model.ApiHive3ReplicationArguments;
import com.cloudera.api.swagger.model.ApiRangerReplicationExportArgs;
import com.cloudera.api.swagger.model.ApiReplicationCommandList;
import com.cloudera.api.swagger.model.ApiReplicationDiagnosticsCollectionArgs;
import com.cloudera.api.swagger.model.ApiReplicationSchedule;
import com.cloudera.api.swagger.model.ApiReplicationScheduleList;
import com.cloudera.api.swagger.model.ApiReplicationState;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ReplicationsResourceApi {
    private ApiClient apiClient;

    public ReplicationsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReplicationsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addHBaseReplicationPeerCall(String clusterName, String serviceName, ApiHBaseAddReplicationPeerInput body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBaseAddReplicationPeerInput localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/addReplicationPeer".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addHBaseReplicationPeerValidateBeforeCall(String clusterName, String serviceName, ApiHBaseAddReplicationPeerInput body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling addHBaseReplicationPeer(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling addHBaseReplicationPeer(Async)");
        }
        Call call = this.addHBaseReplicationPeerCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand addHBaseReplicationPeer(String clusterName, String serviceName, ApiHBaseAddReplicationPeerInput body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.addHBaseReplicationPeerWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> addHBaseReplicationPeerWithHttpInfo(String clusterName, String serviceName, ApiHBaseAddReplicationPeerInput body) throws ApiException {
        Call call = this.addHBaseReplicationPeerValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addHBaseReplicationPeerAsync(String clusterName, String serviceName, ApiHBaseAddReplicationPeerInput body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addHBaseReplicationPeerValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call addTablesToHBasePeerCall(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBasePeerIdWithTableCFs localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/addTablesToHBasePeer".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addTablesToHBasePeerValidateBeforeCall(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling addTablesToHBasePeer(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling addTablesToHBasePeer(Async)");
        }
        Call call = this.addTablesToHBasePeerCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand addTablesToHBasePeer(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.addTablesToHBasePeerWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> addTablesToHBasePeerWithHttpInfo(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body) throws ApiException {
        Call call = this.addTablesToHBasePeerValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addTablesToHBasePeerAsync(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addTablesToHBasePeerValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call checkHBaseTablesExistCall(String clusterName, String serviceName, ApiHBaseTableNames body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBaseTableNames localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/checkTables".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call checkHBaseTablesExistValidateBeforeCall(String clusterName, String serviceName, ApiHBaseTableNames body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling checkHBaseTablesExist(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling checkHBaseTablesExist(Async)");
        }
        Call call = this.checkHBaseTablesExistCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand checkHBaseTablesExist(String clusterName, String serviceName, ApiHBaseTableNames body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.checkHBaseTablesExistWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> checkHBaseTablesExistWithHttpInfo(String clusterName, String serviceName, ApiHBaseTableNames body) throws ApiException {
        Call call = this.checkHBaseTablesExistValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call checkHBaseTablesExistAsync(String clusterName, String serviceName, ApiHBaseTableNames body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.checkHBaseTablesExistValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call collectDiagnosticDataCall(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationDiagnosticsCollectionArgs body, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiReplicationDiagnosticsCollectionArgs localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/collectDiagnosticData".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call collectDiagnosticDataValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationDiagnosticsCollectionArgs body, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling collectDiagnosticData(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling collectDiagnosticData(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling collectDiagnosticData(Async)");
        }
        Call call = this.collectDiagnosticDataCall(clusterName, scheduleId, serviceName, body, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand collectDiagnosticData(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationDiagnosticsCollectionArgs body, String view) throws ApiException {
        ApiResponse<ApiCommand> resp = this.collectDiagnosticDataWithHttpInfo(clusterName, scheduleId, serviceName, body, view);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> collectDiagnosticDataWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationDiagnosticsCollectionArgs body, String view) throws ApiException {
        Call call = this.collectDiagnosticDataValidateBeforeCall(clusterName, scheduleId, serviceName, body, view, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call collectDiagnosticDataAsync(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationDiagnosticsCollectionArgs body, String view, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.collectDiagnosticDataValidateBeforeCall(clusterName, scheduleId, serviceName, body, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createCloudCredstoreOnHdfsCall(String clusterName, String serviceName, Boolean force, String sourceAccount, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/createCloudCredstoreOnHdfs".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (force != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("force", force));
        }
        if (sourceAccount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceAccount", sourceAccount));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createCloudCredstoreOnHdfsValidateBeforeCall(String clusterName, String serviceName, Boolean force, String sourceAccount, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling createCloudCredstoreOnHdfs(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling createCloudCredstoreOnHdfs(Async)");
        }
        Call call = this.createCloudCredstoreOnHdfsCall(clusterName, serviceName, force, sourceAccount, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand createCloudCredstoreOnHdfs(String clusterName, String serviceName, Boolean force, String sourceAccount) throws ApiException {
        ApiResponse<ApiCommand> resp = this.createCloudCredstoreOnHdfsWithHttpInfo(clusterName, serviceName, force, sourceAccount);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> createCloudCredstoreOnHdfsWithHttpInfo(String clusterName, String serviceName, Boolean force, String sourceAccount) throws ApiException {
        Call call = this.createCloudCredstoreOnHdfsValidateBeforeCall(clusterName, serviceName, force, sourceAccount, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createCloudCredstoreOnHdfsAsync(String clusterName, String serviceName, Boolean force, String sourceAccount, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createCloudCredstoreOnHdfsValidateBeforeCall(clusterName, serviceName, force, sourceAccount, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createCredstoreCall(String clusterName, String serviceName, String credstoreDirPath, Boolean force, String sourceAccount, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/createCredstore".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (credstoreDirPath != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("credstoreDirPath", credstoreDirPath));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("force", force));
        }
        if (sourceAccount != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceAccount", sourceAccount));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @Deprecated
    private Call createCredstoreValidateBeforeCall(String clusterName, String serviceName, String credstoreDirPath, Boolean force, String sourceAccount, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling createCredstore(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling createCredstore(Async)");
        }
        Call call = this.createCredstoreCall(clusterName, serviceName, credstoreDirPath, force, sourceAccount, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand createCredstore(String clusterName, String serviceName, String credstoreDirPath, Boolean force, String sourceAccount) throws ApiException {
        ApiResponse<ApiCommand> resp = this.createCredstoreWithHttpInfo(clusterName, serviceName, credstoreDirPath, force, sourceAccount);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> createCredstoreWithHttpInfo(String clusterName, String serviceName, String credstoreDirPath, Boolean force, String sourceAccount) throws ApiException {
        Call call = this.createCredstoreValidateBeforeCall(clusterName, serviceName, credstoreDirPath, force, sourceAccount, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createCredstoreAsync(String clusterName, String serviceName, String credstoreDirPath, Boolean force, String sourceAccount, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createCredstoreValidateBeforeCall(clusterName, serviceName, credstoreDirPath, force, sourceAccount, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSchedulesCall(String clusterName, String serviceName, ApiReplicationScheduleList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiReplicationScheduleList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSchedulesValidateBeforeCall(String clusterName, String serviceName, ApiReplicationScheduleList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling createSchedules(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling createSchedules(Async)");
        }
        Call call = this.createSchedulesCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationScheduleList createSchedules(String clusterName, String serviceName, ApiReplicationScheduleList body) throws ApiException {
        ApiResponse<ApiReplicationScheduleList> resp = this.createSchedulesWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationScheduleList> createSchedulesWithHttpInfo(String clusterName, String serviceName, ApiReplicationScheduleList body) throws ApiException {
        Call call = this.createSchedulesValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSchedulesAsync(String clusterName, String serviceName, ApiReplicationScheduleList body, final ApiCallback<ApiReplicationScheduleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSchedulesValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteAllSchedulesCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteAllSchedulesValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling deleteAllSchedules(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling deleteAllSchedules(Async)");
        }
        Call call = this.deleteAllSchedulesCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationScheduleList deleteAllSchedules(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiReplicationScheduleList> resp = this.deleteAllSchedulesWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationScheduleList> deleteAllSchedulesWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.deleteAllSchedulesValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteAllSchedulesAsync(String clusterName, String serviceName, final ApiCallback<ApiReplicationScheduleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteAllSchedulesValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling deleteSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling deleteSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling deleteSchedule(Async)");
        }
        Call call = this.deleteScheduleCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationSchedule deleteSchedule(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        ApiResponse<ApiReplicationSchedule> resp = this.deleteScheduleWithHttpInfo(clusterName, scheduleId, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationSchedule> deleteScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        Call call = this.deleteScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, final ApiCallback<ApiReplicationSchedule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call exportAtlasEntitesCall(String clusterName, String serviceName, ApiAtlasReplicationRemoteArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiAtlasReplicationRemoteArgs localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/exportAtlasEntities".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call exportAtlasEntitesValidateBeforeCall(String clusterName, String serviceName, ApiAtlasReplicationRemoteArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling exportAtlasEntites(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling exportAtlasEntites(Async)");
        }
        Call call = this.exportAtlasEntitesCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand exportAtlasEntites(String clusterName, String serviceName, ApiAtlasReplicationRemoteArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.exportAtlasEntitesWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> exportAtlasEntitesWithHttpInfo(String clusterName, String serviceName, ApiAtlasReplicationRemoteArgs body) throws ApiException {
        Call call = this.exportAtlasEntitesValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call exportAtlasEntitesAsync(String clusterName, String serviceName, ApiAtlasReplicationRemoteArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.exportAtlasEntitesValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call exportRangerServicesCall(String clusterName, String serviceName, ApiRangerReplicationExportArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRangerReplicationExportArgs localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/exportRangerServices".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call exportRangerServicesValidateBeforeCall(String clusterName, String serviceName, ApiRangerReplicationExportArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling exportRangerServices(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling exportRangerServices(Async)");
        }
        Call call = this.exportRangerServicesCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand exportRangerServices(String clusterName, String serviceName, ApiRangerReplicationExportArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.exportRangerServicesWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> exportRangerServicesWithHttpInfo(String clusterName, String serviceName, ApiRangerReplicationExportArgs body) throws ApiException {
        Call call = this.exportRangerServicesValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call exportRangerServicesAsync(String clusterName, String serviceName, ApiRangerReplicationExportArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.exportRangerServicesValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call fetchHBaseColumnFamiliesCall(String clusterName, String serviceName, ApiHBaseTableNames body, Boolean whereReplicationSet, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBaseTableNames localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/fetchColumnFamilies".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (whereReplicationSet != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("whereReplicationSet", whereReplicationSet));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call fetchHBaseColumnFamiliesValidateBeforeCall(String clusterName, String serviceName, ApiHBaseTableNames body, Boolean whereReplicationSet, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling fetchHBaseColumnFamilies(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling fetchHBaseColumnFamilies(Async)");
        }
        Call call = this.fetchHBaseColumnFamiliesCall(clusterName, serviceName, body, whereReplicationSet, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand fetchHBaseColumnFamilies(String clusterName, String serviceName, ApiHBaseTableNames body, Boolean whereReplicationSet) throws ApiException {
        ApiResponse<ApiCommand> resp = this.fetchHBaseColumnFamiliesWithHttpInfo(clusterName, serviceName, body, whereReplicationSet);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> fetchHBaseColumnFamiliesWithHttpInfo(String clusterName, String serviceName, ApiHBaseTableNames body, Boolean whereReplicationSet) throws ApiException {
        Call call = this.fetchHBaseColumnFamiliesValidateBeforeCall(clusterName, serviceName, body, whereReplicationSet, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call fetchHBaseColumnFamiliesAsync(String clusterName, String serviceName, ApiHBaseTableNames body, Boolean whereReplicationSet, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.fetchHBaseColumnFamiliesValidateBeforeCall(clusterName, serviceName, body, whereReplicationSet, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call fetchHBasePeerInfoCall(String clusterName, String serviceName, ApiHBasePeerId body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBasePeerId localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/fetchHBasePeerInfo".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call fetchHBasePeerInfoValidateBeforeCall(String clusterName, String serviceName, ApiHBasePeerId body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling fetchHBasePeerInfo(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling fetchHBasePeerInfo(Async)");
        }
        Call call = this.fetchHBasePeerInfoCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand fetchHBasePeerInfo(String clusterName, String serviceName, ApiHBasePeerId body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.fetchHBasePeerInfoWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> fetchHBasePeerInfoWithHttpInfo(String clusterName, String serviceName, ApiHBasePeerId body) throws ApiException {
        Call call = this.fetchHBasePeerInfoValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call fetchHBasePeerInfoAsync(String clusterName, String serviceName, ApiHBasePeerId body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.fetchHBasePeerInfoValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call forceDeleteScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/forcedDelete".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call forceDeleteScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling forceDeleteSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling forceDeleteSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling forceDeleteSchedule(Async)");
        }
        Call call = this.forceDeleteScheduleCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationSchedule forceDeleteSchedule(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        ApiResponse<ApiReplicationSchedule> resp = this.forceDeleteScheduleWithHttpInfo(clusterName, scheduleId, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationSchedule> forceDeleteScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        Call call = this.forceDeleteScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call forceDeleteScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, final ApiCallback<ApiReplicationSchedule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.forceDeleteScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateCloudReplCredstorePasswordCall(String clusterName, String serviceName, String passwordGenerateMode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/generateCloudReplCredstorePassword".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (passwordGenerateMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("passwordGenerateMode", passwordGenerateMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateCloudReplCredstorePasswordValidateBeforeCall(String clusterName, String serviceName, String passwordGenerateMode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling generateCloudReplCredstorePassword(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling generateCloudReplCredstorePassword(Async)");
        }
        Call call = this.generateCloudReplCredstorePasswordCall(clusterName, serviceName, passwordGenerateMode, progressListener, progressRequestListener);
        return call;
    }

    public Boolean generateCloudReplCredstorePassword(String clusterName, String serviceName, String passwordGenerateMode) throws ApiException {
        ApiResponse<Boolean> resp = this.generateCloudReplCredstorePasswordWithHttpInfo(clusterName, serviceName, passwordGenerateMode);
        return resp.getData();
    }

    public ApiResponse<Boolean> generateCloudReplCredstorePasswordWithHttpInfo(String clusterName, String serviceName, String passwordGenerateMode) throws ApiException {
        Call call = this.generateCloudReplCredstorePasswordValidateBeforeCall(clusterName, serviceName, passwordGenerateMode, null, null);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateCloudReplCredstorePasswordAsync(String clusterName, String serviceName, String passwordGenerateMode, final ApiCallback<Boolean> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateCloudReplCredstorePasswordValidateBeforeCall(clusterName, serviceName, passwordGenerateMode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getReplicationStateCall(String clusterName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/replicationState".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getReplicationStateValidateBeforeCall(String clusterName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getReplicationState(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling getReplicationState(Async)");
        }
        Call call = this.getReplicationStateCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationState getReplicationState(String clusterName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiReplicationState> resp = this.getReplicationStateWithHttpInfo(clusterName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationState> getReplicationStateWithHttpInfo(String clusterName, String serviceName, String view) throws ApiException {
        Call call = this.getReplicationStateValidateBeforeCall(clusterName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationState>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getReplicationStateAsync(String clusterName, String serviceName, String view, final ApiCallback<ApiReplicationState> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getReplicationStateValidateBeforeCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationState>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call isHive3ReverseDirectionEnabledCall(String clusterName, String serviceName, String clusterUuidOnRemote, String serviceNameOnRemote, String sourceDbNameOnRemote, String targetDbNameOnRemote, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/isHive3ReverseDirectionEnabled".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (clusterUuidOnRemote != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("clusterUuidOnRemote", clusterUuidOnRemote));
        }
        if (serviceNameOnRemote != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("serviceNameOnRemote", serviceNameOnRemote));
        }
        if (sourceDbNameOnRemote != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceDbNameOnRemote", sourceDbNameOnRemote));
        }
        if (targetDbNameOnRemote != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("targetDbNameOnRemote", targetDbNameOnRemote));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call isHive3ReverseDirectionEnabledValidateBeforeCall(String clusterName, String serviceName, String clusterUuidOnRemote, String serviceNameOnRemote, String sourceDbNameOnRemote, String targetDbNameOnRemote, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling isHive3ReverseDirectionEnabled(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling isHive3ReverseDirectionEnabled(Async)");
        }
        Call call = this.isHive3ReverseDirectionEnabledCall(clusterName, serviceName, clusterUuidOnRemote, serviceNameOnRemote, sourceDbNameOnRemote, targetDbNameOnRemote, progressListener, progressRequestListener);
        return call;
    }

    public Boolean isHive3ReverseDirectionEnabled(String clusterName, String serviceName, String clusterUuidOnRemote, String serviceNameOnRemote, String sourceDbNameOnRemote, String targetDbNameOnRemote) throws ApiException {
        ApiResponse<Boolean> resp = this.isHive3ReverseDirectionEnabledWithHttpInfo(clusterName, serviceName, clusterUuidOnRemote, serviceNameOnRemote, sourceDbNameOnRemote, targetDbNameOnRemote);
        return resp.getData();
    }

    public ApiResponse<Boolean> isHive3ReverseDirectionEnabledWithHttpInfo(String clusterName, String serviceName, String clusterUuidOnRemote, String serviceNameOnRemote, String sourceDbNameOnRemote, String targetDbNameOnRemote) throws ApiException {
        Call call = this.isHive3ReverseDirectionEnabledValidateBeforeCall(clusterName, serviceName, clusterUuidOnRemote, serviceNameOnRemote, sourceDbNameOnRemote, targetDbNameOnRemote, null, null);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call isHive3ReverseDirectionEnabledAsync(String clusterName, String serviceName, String clusterUuidOnRemote, String serviceNameOnRemote, String sourceDbNameOnRemote, String targetDbNameOnRemote, final ApiCallback<Boolean> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.isHive3ReverseDirectionEnabledValidateBeforeCall(clusterName, serviceName, clusterUuidOnRemote, serviceNameOnRemote, sourceDbNameOnRemote, targetDbNameOnRemote, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listHBaseNamespacesCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/listNamespaces".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listHBaseNamespacesValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling listHBaseNamespaces(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling listHBaseNamespaces(Async)");
        }
        Call call = this.listHBaseNamespacesCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand listHBaseNamespaces(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiCommand> resp = this.listHBaseNamespacesWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> listHBaseNamespacesWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.listHBaseNamespacesValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listHBaseNamespacesAsync(String clusterName, String serviceName, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listHBaseNamespacesValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listHBasePeersCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/listPeers".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listHBasePeersValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling listHBasePeers(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling listHBasePeers(Async)");
        }
        Call call = this.listHBasePeersCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand listHBasePeers(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiCommand> resp = this.listHBasePeersWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> listHBasePeersWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.listHBasePeersValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listHBasePeersAsync(String clusterName, String serviceName, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listHBasePeersValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listHBaseTablesCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/listTables".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listHBaseTablesValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling listHBaseTables(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling listHBaseTables(Async)");
        }
        Call call = this.listHBaseTablesCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand listHBaseTables(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiCommand> resp = this.listHBaseTablesWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> listHBaseTablesWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.listHBaseTablesValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listHBaseTablesAsync(String clusterName, String serviceName, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listHBaseTablesValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCopyReconciliationCall(String clusterName, BigDecimal scheduleId, String serviceName, Boolean pcrEnableCrcCheck, Boolean pcrEnableLengthCheck, Boolean pcrEnableModtimeCheck, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/postCopyReconciliation".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pcrEnableCrcCheck != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pcrEnableCrcCheck", pcrEnableCrcCheck));
        }
        if (pcrEnableLengthCheck != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pcrEnableLengthCheck", pcrEnableLengthCheck));
        }
        if (pcrEnableModtimeCheck != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pcrEnableModtimeCheck", pcrEnableModtimeCheck));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCopyReconciliationValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, Boolean pcrEnableCrcCheck, Boolean pcrEnableLengthCheck, Boolean pcrEnableModtimeCheck, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling postCopyReconciliation(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling postCopyReconciliation(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling postCopyReconciliation(Async)");
        }
        Call call = this.postCopyReconciliationCall(clusterName, scheduleId, serviceName, pcrEnableCrcCheck, pcrEnableLengthCheck, pcrEnableModtimeCheck, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand postCopyReconciliation(String clusterName, BigDecimal scheduleId, String serviceName, Boolean pcrEnableCrcCheck, Boolean pcrEnableLengthCheck, Boolean pcrEnableModtimeCheck) throws ApiException {
        ApiResponse<ApiCommand> resp = this.postCopyReconciliationWithHttpInfo(clusterName, scheduleId, serviceName, pcrEnableCrcCheck, pcrEnableLengthCheck, pcrEnableModtimeCheck);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> postCopyReconciliationWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, Boolean pcrEnableCrcCheck, Boolean pcrEnableLengthCheck, Boolean pcrEnableModtimeCheck) throws ApiException {
        Call call = this.postCopyReconciliationValidateBeforeCall(clusterName, scheduleId, serviceName, pcrEnableCrcCheck, pcrEnableLengthCheck, pcrEnableModtimeCheck, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCopyReconciliationAsync(String clusterName, BigDecimal scheduleId, String serviceName, Boolean pcrEnableCrcCheck, Boolean pcrEnableLengthCheck, Boolean pcrEnableModtimeCheck, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCopyReconciliationValidateBeforeCall(clusterName, scheduleId, serviceName, pcrEnableCrcCheck, pcrEnableLengthCheck, pcrEnableModtimeCheck, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readHistoryCall(String clusterName, BigDecimal scheduleId, String serviceName, BigDecimal limit, BigDecimal offset, String sort, String status, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/history".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readHistoryValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, BigDecimal limit, BigDecimal offset, String sort, String status, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readHistory(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling readHistory(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readHistory(Async)");
        }
        Call call = this.readHistoryCall(clusterName, scheduleId, serviceName, limit, offset, sort, status, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationCommandList readHistory(String clusterName, BigDecimal scheduleId, String serviceName, BigDecimal limit, BigDecimal offset, String sort, String status, String view) throws ApiException {
        ApiResponse<ApiReplicationCommandList> resp = this.readHistoryWithHttpInfo(clusterName, scheduleId, serviceName, limit, offset, sort, status, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationCommandList> readHistoryWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, BigDecimal limit, BigDecimal offset, String sort, String status, String view) throws ApiException {
        Call call = this.readHistoryValidateBeforeCall(clusterName, scheduleId, serviceName, limit, offset, sort, status, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationCommandList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readHistoryAsync(String clusterName, BigDecimal scheduleId, String serviceName, BigDecimal limit, BigDecimal offset, String sort, String status, String view, final ApiCallback<ApiReplicationCommandList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readHistoryValidateBeforeCall(clusterName, scheduleId, serviceName, limit, offset, sort, status, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationCommandList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling readSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readSchedule(Async)");
        }
        Call call = this.readScheduleCall(clusterName, scheduleId, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationSchedule readSchedule(String clusterName, BigDecimal scheduleId, String serviceName, String view) throws ApiException {
        ApiResponse<ApiReplicationSchedule> resp = this.readScheduleWithHttpInfo(clusterName, scheduleId, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationSchedule> readScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, String view) throws ApiException {
        Call call = this.readScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, String view, final ApiCallback<ApiReplicationSchedule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readSchedulesCall(String clusterName, String serviceName, BigDecimal maxCommands, BigDecimal maxErrors, BigDecimal maxSchedules, BigDecimal maxTables, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (maxCommands != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxCommands", maxCommands));
        }
        if (maxErrors != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxErrors", maxErrors));
        }
        if (maxSchedules != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxSchedules", maxSchedules));
        }
        if (maxTables != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("maxTables", maxTables));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readSchedulesValidateBeforeCall(String clusterName, String serviceName, BigDecimal maxCommands, BigDecimal maxErrors, BigDecimal maxSchedules, BigDecimal maxTables, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readSchedules(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readSchedules(Async)");
        }
        Call call = this.readSchedulesCall(clusterName, serviceName, maxCommands, maxErrors, maxSchedules, maxTables, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationScheduleList readSchedules(String clusterName, String serviceName, BigDecimal maxCommands, BigDecimal maxErrors, BigDecimal maxSchedules, BigDecimal maxTables, String view) throws ApiException {
        ApiResponse<ApiReplicationScheduleList> resp = this.readSchedulesWithHttpInfo(clusterName, serviceName, maxCommands, maxErrors, maxSchedules, maxTables, view);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationScheduleList> readSchedulesWithHttpInfo(String clusterName, String serviceName, BigDecimal maxCommands, BigDecimal maxErrors, BigDecimal maxSchedules, BigDecimal maxTables, String view) throws ApiException {
        Call call = this.readSchedulesValidateBeforeCall(clusterName, serviceName, maxCommands, maxErrors, maxSchedules, maxTables, view, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readSchedulesAsync(String clusterName, String serviceName, BigDecimal maxCommands, BigDecimal maxErrors, BigDecimal maxSchedules, BigDecimal maxTables, String view, final ApiCallback<ApiReplicationScheduleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readSchedulesValidateBeforeCall(clusterName, serviceName, maxCommands, maxErrors, maxSchedules, maxTables, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationScheduleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call recreateCloudCredstoresOnHdfsCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/recreateCloudCredstoresOnHdfs".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call recreateCloudCredstoresOnHdfsValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling recreateCloudCredstoresOnHdfs(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling recreateCloudCredstoresOnHdfs(Async)");
        }
        Call call = this.recreateCloudCredstoresOnHdfsCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand recreateCloudCredstoresOnHdfs(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiCommand> resp = this.recreateCloudCredstoresOnHdfsWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> recreateCloudCredstoresOnHdfsWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.recreateCloudCredstoresOnHdfsValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call recreateCloudCredstoresOnHdfsAsync(String clusterName, String serviceName, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.recreateCloudCredstoresOnHdfsValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeHBasePeerCall(String clusterName, String serviceName, ApiHBasePeerId body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBasePeerId localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/removeHBasePeer".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeHBasePeerValidateBeforeCall(String clusterName, String serviceName, ApiHBasePeerId body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling removeHBasePeer(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling removeHBasePeer(Async)");
        }
        Call call = this.removeHBasePeerCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand removeHBasePeer(String clusterName, String serviceName, ApiHBasePeerId body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.removeHBasePeerWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> removeHBasePeerWithHttpInfo(String clusterName, String serviceName, ApiHBasePeerId body) throws ApiException {
        Call call = this.removeHBasePeerValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeHBasePeerAsync(String clusterName, String serviceName, ApiHBasePeerId body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeHBasePeerValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeTablesFromHBasePeerCall(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBasePeerIdWithTableCFs localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/removeTablesFromHBasePeer".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeTablesFromHBasePeerValidateBeforeCall(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling removeTablesFromHBasePeer(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling removeTablesFromHBasePeer(Async)");
        }
        Call call = this.removeTablesFromHBasePeerCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand removeTablesFromHBasePeer(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.removeTablesFromHBasePeerWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> removeTablesFromHBasePeerWithHttpInfo(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body) throws ApiException {
        Call call = this.removeTablesFromHBasePeerValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeTablesFromHBasePeerAsync(String clusterName, String serviceName, ApiHBasePeerIdWithTableCFs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeTablesFromHBasePeerValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call rescheduleHive3ReplicationMetricsGetterCall(String clusterName, String serviceName, BigDecimal nextStartMins, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/rescheduleHive3ReplicationMetricsGetter".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (nextStartMins != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextStartMins", nextStartMins));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call rescheduleHive3ReplicationMetricsGetterValidateBeforeCall(String clusterName, String serviceName, BigDecimal nextStartMins, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling rescheduleHive3ReplicationMetricsGetter(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling rescheduleHive3ReplicationMetricsGetter(Async)");
        }
        Call call = this.rescheduleHive3ReplicationMetricsGetterCall(clusterName, serviceName, nextStartMins, progressListener, progressRequestListener);
        return call;
    }

    public Boolean rescheduleHive3ReplicationMetricsGetter(String clusterName, String serviceName, BigDecimal nextStartMins) throws ApiException {
        ApiResponse<Boolean> resp = this.rescheduleHive3ReplicationMetricsGetterWithHttpInfo(clusterName, serviceName, nextStartMins);
        return resp.getData();
    }

    public ApiResponse<Boolean> rescheduleHive3ReplicationMetricsGetterWithHttpInfo(String clusterName, String serviceName, BigDecimal nextStartMins) throws ApiException {
        Call call = this.rescheduleHive3ReplicationMetricsGetterValidateBeforeCall(clusterName, serviceName, nextStartMins, null, null);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call rescheduleHive3ReplicationMetricsGetterAsync(String clusterName, String serviceName, BigDecimal nextStartMins, final ApiCallback<Boolean> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.rescheduleHive3ReplicationMetricsGetterValidateBeforeCall(clusterName, serviceName, nextStartMins, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runCopyListingCall(String clusterName, String serviceName, String body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/hdfsCopyListing".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runCopyListingValidateBeforeCall(String clusterName, String serviceName, String body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runCopyListing(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runCopyListing(Async)");
        }
        Call call = this.runCopyListingCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runCopyListing(String clusterName, String serviceName, String body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runCopyListingWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runCopyListingWithHttpInfo(String clusterName, String serviceName, String body) throws ApiException {
        Call call = this.runCopyListingValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runCopyListingAsync(String clusterName, String serviceName, String body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runCopyListingValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runHBaseReplicationRetryFailedSnapshotsCall(String clusterName, BigDecimal scheduleId, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/runHBaseReplicationRetryFailedSnapshots".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runHBaseReplicationRetryFailedSnapshotsValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runHBaseReplicationRetryFailedSnapshots(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling runHBaseReplicationRetryFailedSnapshots(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runHBaseReplicationRetryFailedSnapshots(Async)");
        }
        Call call = this.runHBaseReplicationRetryFailedSnapshotsCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runHBaseReplicationRetryFailedSnapshots(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runHBaseReplicationRetryFailedSnapshotsWithHttpInfo(clusterName, scheduleId, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runHBaseReplicationRetryFailedSnapshotsWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName) throws ApiException {
        Call call = this.runHBaseReplicationRetryFailedSnapshotsValidateBeforeCall(clusterName, scheduleId, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runHBaseReplicationRetryFailedSnapshotsAsync(String clusterName, BigDecimal scheduleId, String serviceName, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runHBaseReplicationRetryFailedSnapshotsValidateBeforeCall(clusterName, scheduleId, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runHBaseReplicationSecurityToolCall(String clusterName, String serviceName, Map<String, String> body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Map<String, String> localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/hbaseReplicationSecurityTool".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runHBaseReplicationSecurityToolValidateBeforeCall(String clusterName, String serviceName, Map<String, String> body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runHBaseReplicationSecurityTool(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runHBaseReplicationSecurityTool(Async)");
        }
        Call call = this.runHBaseReplicationSecurityToolCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runHBaseReplicationSecurityTool(String clusterName, String serviceName, Map<String, String> body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runHBaseReplicationSecurityToolWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runHBaseReplicationSecurityToolWithHttpInfo(String clusterName, String serviceName, Map<String, String> body) throws ApiException {
        Call call = this.runHBaseReplicationSecurityToolValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runHBaseReplicationSecurityToolAsync(String clusterName, String serviceName, Map<String, String> body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runHBaseReplicationSecurityToolValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runHBaseReplicationValidationToolCall(String clusterName, String serviceName, String hbasePeerId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/hbaseReplicationValidationTool".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (hbasePeerId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("hbasePeerId", hbasePeerId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runHBaseReplicationValidationToolValidateBeforeCall(String clusterName, String serviceName, String hbasePeerId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runHBaseReplicationValidationTool(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runHBaseReplicationValidationTool(Async)");
        }
        Call call = this.runHBaseReplicationValidationToolCall(clusterName, serviceName, hbasePeerId, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runHBaseReplicationValidationTool(String clusterName, String serviceName, String hbasePeerId) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runHBaseReplicationValidationToolWithHttpInfo(clusterName, serviceName, hbasePeerId);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runHBaseReplicationValidationToolWithHttpInfo(String clusterName, String serviceName, String hbasePeerId) throws ApiException {
        Call call = this.runHBaseReplicationValidationToolValidateBeforeCall(clusterName, serviceName, hbasePeerId, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runHBaseReplicationValidationToolAsync(String clusterName, String serviceName, String hbasePeerId, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runHBaseReplicationValidationToolValidateBeforeCall(clusterName, serviceName, hbasePeerId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runHiveReplicationQueryCall(String clusterName, String serviceName, ApiHive3ReplicationArguments body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHive3ReplicationArguments localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/hiveReplicationQuery".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runHiveReplicationQueryValidateBeforeCall(String clusterName, String serviceName, ApiHive3ReplicationArguments body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runHiveReplicationQuery(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runHiveReplicationQuery(Async)");
        }
        Call call = this.runHiveReplicationQueryCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runHiveReplicationQuery(String clusterName, String serviceName, ApiHive3ReplicationArguments body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runHiveReplicationQueryWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runHiveReplicationQueryWithHttpInfo(String clusterName, String serviceName, ApiHive3ReplicationArguments body) throws ApiException {
        Call call = this.runHiveReplicationQueryValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runHiveReplicationQueryAsync(String clusterName, String serviceName, ApiHive3ReplicationArguments body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runHiveReplicationQueryValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call runScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}/run".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dryRun != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dryRun", dryRun));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call runScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling runSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling runSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling runSchedule(Async)");
        }
        Call call = this.runScheduleCall(clusterName, scheduleId, serviceName, dryRun, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand runSchedule(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun) throws ApiException {
        ApiResponse<ApiCommand> resp = this.runScheduleWithHttpInfo(clusterName, scheduleId, serviceName, dryRun);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> runScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun) throws ApiException {
        Call call = this.runScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, dryRun, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call runScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, Boolean dryRun, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.runScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, dryRun, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setCFsReplicationScopeCall(String clusterName, String serviceName, ApiHBaseSetCFsReplicationScope body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBaseSetCFsReplicationScope localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/setCFsReplicationScope".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setCFsReplicationScopeValidateBeforeCall(String clusterName, String serviceName, ApiHBaseSetCFsReplicationScope body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling setCFsReplicationScope(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling setCFsReplicationScope(Async)");
        }
        Call call = this.setCFsReplicationScopeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand setCFsReplicationScope(String clusterName, String serviceName, ApiHBaseSetCFsReplicationScope body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.setCFsReplicationScopeWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> setCFsReplicationScopeWithHttpInfo(String clusterName, String serviceName, ApiHBaseSetCFsReplicationScope body) throws ApiException {
        Call call = this.setCFsReplicationScopeValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setCFsReplicationScopeAsync(String clusterName, String serviceName, ApiHBaseSetCFsReplicationScope body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setCFsReplicationScopeValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateHBasePeerStateCall(String clusterName, String serviceName, ApiHBaseReplicationUpdatePeerStateArgs body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBaseReplicationUpdatePeerStateArgs localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/updateHBasePeerState".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateHBasePeerStateValidateBeforeCall(String clusterName, String serviceName, ApiHBaseReplicationUpdatePeerStateArgs body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updateHBasePeerState(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling updateHBasePeerState(Async)");
        }
        Call call = this.updateHBasePeerStateCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand updateHBasePeerState(String clusterName, String serviceName, ApiHBaseReplicationUpdatePeerStateArgs body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.updateHBasePeerStateWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> updateHBasePeerStateWithHttpInfo(String clusterName, String serviceName, ApiHBaseReplicationUpdatePeerStateArgs body) throws ApiException {
        Call call = this.updateHBasePeerStateValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateHBasePeerStateAsync(String clusterName, String serviceName, ApiHBaseReplicationUpdatePeerStateArgs body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateHBasePeerStateValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateHBaseReplicationPeerStateCall(String clusterName, String serviceName, ApiHBaseUpdateReplicationPeerState body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiHBaseUpdateReplicationPeerState localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/operations/updateReplicationPeerState".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateHBaseReplicationPeerStateValidateBeforeCall(String clusterName, String serviceName, ApiHBaseUpdateReplicationPeerState body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updateHBaseReplicationPeerState(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling updateHBaseReplicationPeerState(Async)");
        }
        Call call = this.updateHBaseReplicationPeerStateCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand updateHBaseReplicationPeerState(String clusterName, String serviceName, ApiHBaseUpdateReplicationPeerState body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.updateHBaseReplicationPeerStateWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> updateHBaseReplicationPeerStateWithHttpInfo(String clusterName, String serviceName, ApiHBaseUpdateReplicationPeerState body) throws ApiException {
        Call call = this.updateHBaseReplicationPeerStateValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateHBaseReplicationPeerStateAsync(String clusterName, String serviceName, ApiHBaseUpdateReplicationPeerState body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateHBaseReplicationPeerStateValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateScheduleCall(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiReplicationSchedule localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/replications/{scheduleId}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{scheduleId\\}", this.apiClient.escapeString(scheduleId.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateScheduleValidateBeforeCall(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updateSchedule(Async)");
        }
        if (scheduleId == null) {
            throw new ApiException("Missing the required parameter 'scheduleId' when calling updateSchedule(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling updateSchedule(Async)");
        }
        Call call = this.updateScheduleCall(clusterName, scheduleId, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiReplicationSchedule updateSchedule(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body) throws ApiException {
        ApiResponse<ApiReplicationSchedule> resp = this.updateScheduleWithHttpInfo(clusterName, scheduleId, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiReplicationSchedule> updateScheduleWithHttpInfo(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body) throws ApiException {
        Call call = this.updateScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateScheduleAsync(String clusterName, BigDecimal scheduleId, String serviceName, ApiReplicationSchedule body, final ApiCallback<ApiReplicationSchedule> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateScheduleValidateBeforeCall(clusterName, scheduleId, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiReplicationSchedule>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

