/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.shell.AbstractCredentialCollector;
import org.apache.knox.gateway.shell.CredentialCollectionException;
import org.apache.knox.gateway.util.JsonUtils;

public class KnoxTokenCredentialCollector
extends AbstractCredentialCollector {
    public static final String COLLECTOR_TYPE = "KnoxToken";
    private static final String KNOXTOKENCACHE = ".knoxtokencache";
    private String targetUrl;
    private String tokenType;
    private String endpointPublicCertPem;
    private long expiresIn;

    @Override
    public void collect() throws CredentialCollectionException {
        block4: {
            try {
                String knoxtoken = this.getCachedKnoxToken();
                if (knoxtoken != null) {
                    Date expires;
                    Map attrs = JsonUtils.getMapFromJsonString((String)knoxtoken);
                    this.value = (String)attrs.get("access_token");
                    this.targetUrl = (String)attrs.get("target_url");
                    this.tokenType = (String)attrs.get("token_type");
                    this.endpointPublicCertPem = (String)attrs.get("endpoint_public_cert");
                    this.expiresIn = Long.parseLong((String)attrs.get("expires_in"));
                    if (this.expiresIn > 0L && (expires = new Date(this.expiresIn)).before(new Date())) {
                        throw new CredentialCollectionException("Cached knox token has expired. Please relogin through knoxinit.");
                    }
                    break block4;
                }
                throw new CredentialCollectionException("Cached knox token cannot be found. Please login through knoxinit.");
            }
            catch (IOException e) {
                throw new CredentialCollectionException("Cached knox token cannot be read. Please login through knoxinit.", e);
            }
        }
    }

    protected String getCachedKnoxToken() throws IOException {
        Path path;
        List<String> lines;
        String line = null;
        String userDir = System.getProperty("user.home");
        File knoxtoken = new File(userDir, KNOXTOKENCACHE);
        if (knoxtoken.exists() && !(lines = Files.readAllLines(path = Paths.get(knoxtoken.toURI()), StandardCharsets.UTF_8)).isEmpty()) {
            line = lines.get(0);
        }
        return line;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getEndpointClientCertPEM() {
        return this.endpointPublicCertPem;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public String type() {
        return COLLECTOR_TYPE;
    }
}

