/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.DefaultServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class StaticServiceDiscovery
extends DefaultServiceDiscovery {
    private final List<ServiceDefinition> services;

    public StaticServiceDiscovery() {
        this.services = new ArrayList<ServiceDefinition>();
    }

    public StaticServiceDiscovery(List<ServiceDefinition> servers) {
        this.services = new ArrayList<ServiceDefinition>(servers);
    }

    public void setServers(List<String> servers) {
        this.services.clear();
        servers.forEach(this::addServer);
    }

    public void addServers(String serviceName, List<String> servers) {
        for (String server : servers) {
            String host = StringHelper.before((String)server, (String)":");
            String port = StringHelper.after((String)server, (String)":");
            if (!ObjectHelper.isNotEmpty((Object)host) || !ObjectHelper.isNotEmpty((Object)port)) continue;
            this.addServer(DefaultServiceDefinition.builder().withName(serviceName).withHost(host).withPort(Integer.parseInt(port)).build());
        }
    }

    public void setServers(String servers) {
        this.services.clear();
        this.addServer(servers);
    }

    public void addServer(ServiceDefinition server) {
        this.services.add(server);
    }

    public void addServer(String serverString) {
        DefaultServiceDefinition.parse(serverString).forEach(this::addServer);
    }

    public void removeServer(Predicate<ServiceDefinition> condition) {
        this.services.removeIf(condition);
    }

    @Override
    public List<ServiceDefinition> getServices(String name) {
        return Collections.unmodifiableList(this.services.stream().filter(s -> Objects.isNull(s.getName()) || Objects.equals(name, s.getName())).collect(Collectors.toList()));
    }

    public static StaticServiceDiscovery forServices(Collection<ServiceDefinition> definitions) {
        StaticServiceDiscovery discovery = new StaticServiceDiscovery();
        for (ServiceDefinition definition : definitions) {
            discovery.addServer(definition);
        }
        return discovery;
    }

    public static StaticServiceDiscovery forServices(ServiceDefinition ... definitions) {
        StaticServiceDiscovery discovery = new StaticServiceDiscovery();
        for (ServiceDefinition definition : definitions) {
            discovery.addServer(definition);
        }
        return discovery;
    }
}

