/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.quota.SensorAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationQuotaManager
implements ReplicaQuota {
    public static final List<Integer> ALL_REPLICAS = List.of(Integer.valueOf(-1));
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationQuotaManager.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<String, List<Integer>> throttledPartitions = new ConcurrentHashMap();
    private final ReplicationQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType replicationType;
    private final Time time;
    private final SensorAccess sensorAccess;
    private final MetricName rateMetricName;
    private Quota quota;

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType replicationType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.replicationType = replicationType;
        this.time = time;
        this.sensorAccess = new SensorAccess((ReadWriteLock)this.lock, metrics);
        this.rateMetricName = metrics.metricName("byte-rate", replicationType.toString(), "Tracking byte-rate for " + String.valueOf(replicationType));
    }

    public void updateQuota(Quota quota) {
        this.lock.writeLock().lock();
        try {
            this.quota = quota;
            KafkaMetric metric = (KafkaMetric)this.metrics.metrics().get(this.rateMetricName);
            if (metric != null) {
                metric.config(this.getQuotaMetricConfig(quota));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.sensor().checkQuotas();
            return false;
        }
        catch (QuotaViolationException qve) {
            LOGGER.trace("{}: Quota violated for sensor ({}), metric: ({}), metric-value: ({}), bound: ({})", new Object[]{this.replicationType, this.sensor().name(), qve.metric().metricName(), qve.value(), qve.bound()});
            return true;
        }
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        List<Integer> partitions = this.throttledPartitions.get(topicPartition.topic());
        return partitions != null && (partitions.equals(ALL_REPLICAS) || partitions.contains(topicPartition.partition()));
    }

    @Override
    public void record(long value) {
        this.sensor().record((double)value, this.time.milliseconds(), false);
    }

    public void markThrottled(String topic, List<Integer> partitions) {
        this.throttledPartitions.put(topic, partitions);
    }

    public void markThrottled(String topic) {
        this.markThrottled(topic, ALL_REPLICAS);
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions.remove(topic);
    }

    public long upperBound() {
        this.lock.readLock().lock();
        try {
            long l = this.quota != null ? (long)this.quota.bound() : Long.MAX_VALUE;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config.quotaWindowSizeSeconds, TimeUnit.SECONDS).samples(this.config.numQuotaSamples).quota(quota);
    }

    private Sensor sensor() {
        return this.sensorAccess.getOrCreate(this.replicationType.toString(), 3600L, sensor -> sensor.add(this.rateMetricName, (MeasurableStat)new SimpleRate(), this.getQuotaMetricConfig(this.quota)));
    }
}

