/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.standalone;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.standalone.StandaloneHerder;
import org.apache.kafka.connect.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HealthCheckThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckThread.class);
    private final StandaloneHerder herder;
    private final Queue<Callback<Void>> callbacks;
    private volatile boolean running;

    public HealthCheckThread(StandaloneHerder herder) {
        this.herder = herder;
        this.callbacks = new LinkedList<Callback<Void>>();
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block10: while (true) {
            try {
                while (true) {
                    Callback<Void> callback;
                    Object object = this;
                    synchronized (object) {
                        while (this.running && this.callbacks.isEmpty()) {
                            this.wait();
                        }
                        if (!this.running) {
                            break block10;
                        }
                        callback = this.callbacks.remove();
                    }
                    object = this.herder;
                    synchronized (object) {
                        try {
                            callback.onCompletion(null, null);
                        }
                        catch (Throwable t) {
                            log.warn("Failed to complete health check callback", t);
                        }
                    }
                }
            }
            catch (Throwable t) {
                log.warn("Health check thread encountered unexpected error", t);
                continue;
            }
            break;
        }
        ConnectException shuttingDown = new ConnectException("The herder is shutting down");
        while (!this.callbacks.isEmpty()) {
            try {
                this.callbacks.remove().onCompletion(shuttingDown, null);
            }
            catch (Throwable t) {
                log.warn("Failed to complete health check callback during shutdown", t);
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(Callback<Void> callback) {
        if (callback == null) {
            log.warn("Ignoring null callback");
            return;
        }
        HealthCheckThread healthCheckThread = this;
        synchronized (healthCheckThread) {
            if (!this.running) {
                throw new IllegalStateException("Cannot check herder health after thread has been shut down");
            }
            this.callbacks.add(callback);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        HealthCheckThread healthCheckThread = this;
        synchronized (healthCheckThread) {
            this.running = false;
            this.notifyAll();
        }
        try {
            this.join();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted during graceful shutdown; will interrupt health check thread and then return immediately without waiting for thread to terminate", (Throwable)e);
            this.interrupt();
            Thread.currentThread().interrupt();
        }
    }
}

