/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.icons.DarkSVGIcon;
import com.github.weisj.darklaf.icons.IconColorMapper;
import com.github.weisj.darklaf.icons.MutableThemedIcon;
import com.github.weisj.darklaf.icons.ThemedSVGIcon;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class CustomThemedIcon
extends ThemedSVGIcon
implements MutableThemedIcon {
    public static final Map<Object, Object> LAF_CONTEXT = null;
    private Map<Object, Object> defaults;
    private Map<Object, Object> contextDefaults;
    private boolean derived;

    public CustomThemedIcon(Supplier<URI> uriSupplier, int displayWidth, int displayHeight) {
        this(uriSupplier, displayWidth, displayHeight, null);
    }

    public CustomThemedIcon(Supplier<URI> uriSupplier, int displayWidth, int displayHeight, Map<Object, Object> colors) {
        super(uriSupplier, displayWidth, displayHeight);
        this.defaults = colors;
    }

    public CustomThemedIcon(URI uri, int displayWidth, int displayHeight, Map<Object, Object> colors) {
        super(uri, displayWidth, displayHeight);
        this.defaults = colors;
    }

    public CustomThemedIcon(DarkSVGIcon icon) {
        this(icon, LAF_CONTEXT, MergeMode.KEEP_REFERENCES);
    }

    public CustomThemedIcon(DarkSVGIcon icon, Map<Object, Object> contextDefaults, MergeMode mergeMode) {
        super(icon.getUri(), icon.getIconWidth(), icon.getIconHeight());
        this.setContextProperties(contextDefaults);
        this.ensureLoaded(false);
        this.defaults = IconColorMapper.getProperties(this.getSVGIcon());
        this.mergeProperties(mergeMode, icon);
    }

    public void mergeProperties(MergeMode mergeMode, DarkSVGIcon originalIcon) {
        if (mergeMode != MergeMode.KEEP_REFERENCES && this.contextDefaults != null) {
            String referencePrefix = PropertyLoader.getReferencePrefix();
            if (!(originalIcon instanceof CustomThemedIcon)) {
                if (mergeMode == MergeMode.REMOVE_REFERENCES) {
                    this.defaults.clear();
                } else {
                    this.defaults.entrySet().forEach(e -> e.setValue(referencePrefix + e.getKey()));
                }
            } else {
                Map<Object, Object> originalProperties = ((CustomThemedIcon)originalIcon).getProperties();
                this.defaults.keySet().forEach(k -> {
                    if (!originalProperties.containsKey(k) && this.contextDefaults.containsKey(k)) {
                        if (mergeMode == MergeMode.REMOVE_REFERENCES) {
                            this.defaults.remove(k);
                        } else {
                            this.defaults.put(referencePrefix + k, this.defaults.remove(k));
                        }
                    }
                });
            }
            this.invalidate();
        }
    }

    protected CustomThemedIcon(int width, int height, CustomThemedIcon icon) {
        super(width, height, icon);
        this.defaults = icon.defaults;
        this.derived = true;
    }

    @Override
    public Map<Object, Object> getProperties() {
        if (this.defaults == null) {
            this.defaults = new HashMap<Object, Object>();
            return this.defaults;
        }
        if (this.derived) {
            this.defaults = new HashMap<Object, Object>(this.defaults);
            this.derived = false;
        }
        return this.defaults;
    }

    @Override
    public void setProperties(Map<Object, Object> props) {
        this.defaults = props;
        this.invalidate();
    }

    @Override
    public CustomThemedIcon derive(int width, int height) {
        return new CustomThemedIcon(width, height, this);
    }

    @Override
    protected SVGIcon createSVGIcon() {
        SVGIcon icon = new SVGIcon();
        icon.setSvgUniverse(new SVGUniverse());
        return icon;
    }

    @Override
    public Map<Object, Object> getContextProperties() {
        return this.contextDefaults != LAF_CONTEXT ? this.contextDefaults : this.getContextDefaults();
    }

    @Override
    public void setContextProperties(Map<Object, Object> props) {
        this.contextDefaults = props;
        this.invalidate();
    }

    @Override
    protected void patchColors() {
        IconColorMapper.patchColors(this.getSVGIcon(), this.getProperties(), this.getContextProperties());
    }

    public static enum MergeMode {
        REMOVE_REFERENCES,
        REPLACE_REFERENCES,
        KEEP_REFERENCES;

    }
}

