/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.Checksum;
import org.jetbrains.letsPlot.util.pngj.DeflatedChunksSet;
import org.jetbrains.letsPlot.util.pngj.Deinterlacer;
import org.jetbrains.letsPlot.util.pngj.FilterType;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.Inflater;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;
import org.jetbrains.letsPlot.util.pngj.RowInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0014J\b\u0010#\u001a\u00020\u001fH\u0014J\b\u0010$\u001a\u00020!H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010%\u001a\u00020\u001fH\u0002J#\u0010+\u001a\u00020!2\u0016\u0010,\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010.0-\"\u0004\u0018\u00010.\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00060"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/IdatSet;", "Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet;", "id", "", "callbackMode", "", "iminfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "deinterlacer", "Lorg/jetbrains/letsPlot/util/pngj/Deinterlacer;", "(Ljava/lang/String;ZLorg/jetbrains/letsPlot/util/pngj/ImageInfo;Lorg/jetbrains/letsPlot/util/pngj/Deinterlacer;)V", "inf", "Lorg/jetbrains/letsPlot/util/pngj/Inflater;", "buffer", "", "(Ljava/lang/String;ZLorg/jetbrains/letsPlot/util/pngj/ImageInfo;Lorg/jetbrains/letsPlot/util/pngj/Deinterlacer;Lorg/jetbrains/letsPlot/util/pngj/Inflater;[B)V", "filterUseStat", "", "imgInfo", "isRowReady", "()Z", "rowUnfilteredPrev", "rowinfo", "Lorg/jetbrains/letsPlot/util/pngj/RowInfo;", "getRowinfo$plot_api", "()Lorg/jetbrains/letsPlot/util/pngj/RowInfo;", "<set-?>", "unfilteredRow", "getUnfilteredRow", "()[B", "advanceToNextRow", "", "close", "", "preProcessRow", "processRowCallback", "unfilterRow", "nbytes", "unfilterRowAverage", "unfilterRowNone", "unfilterRowPaeth", "unfilterRowSub", "unfilterRowUp", "updateCrcs", "idatCrcs", "", "Lorg/jetbrains/letsPlot/util/pngj/Checksum;", "([Lorg/jetbrains/letsPlot/util/pngj/Checksum;)V", "plot-api"})
public final class IdatSet
extends DeflatedChunksSet {
    private final boolean callbackMode;
    @Nullable
    private byte[] unfilteredRow;
    @Nullable
    private byte[] rowUnfilteredPrev;
    @NotNull
    private final ImageInfo imgInfo;
    @Nullable
    private final Deinterlacer deinterlacer;
    @NotNull
    private final RowInfo rowinfo;
    @NotNull
    private int[] filterUseStat;

    public IdatSet(@NotNull String id, boolean callbackMode, @NotNull ImageInfo iminfo, @Nullable Deinterlacer deinterlacer, @Nullable Inflater inf, @Nullable byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)iminfo, (String)"iminfo");
        Deinterlacer deinterlacer2 = deinterlacer;
        super(id, callbackMode, deinterlacer2 != null ? deinterlacer2.getBytesToRead() + 1 : iminfo.getBytesPerRow() + 1, iminfo.getBytesPerRow() + 1, inf, buffer);
        this.callbackMode = callbackMode;
        this.filterUseStat = new int[5];
        this.imgInfo = iminfo;
        this.deinterlacer = deinterlacer;
        this.rowinfo = new RowInfo(iminfo, deinterlacer);
        System.out.println((Object)"Creating IDAT set ");
    }

    @Nullable
    public final byte[] getUnfilteredRow() {
        return this.unfilteredRow;
    }

    @NotNull
    public final RowInfo getRowinfo$plot_api() {
        return this.rowinfo;
    }

    public IdatSet(@NotNull String id, boolean callbackMode, @NotNull ImageInfo iminfo, @Nullable Deinterlacer deinterlacer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)iminfo, (String)"iminfo");
        this(id, callbackMode, iminfo, deinterlacer, null, null);
    }

    private final void unfilterRow() {
        this.unfilterRow(this.rowinfo.getBytesRow());
    }

    private final void unfilterRow(int nbytes) {
        block13: {
            block12: {
                if (this.unfilteredRow == null) break block12;
                Intrinsics.checkNotNull((Object)this.unfilteredRow);
                int n = this.unfilteredRow.length;
                byte[] byArray = this.getRow();
                Intrinsics.checkNotNull((Object)byArray);
                if (n >= byArray.length) break block13;
            }
            byte[] byArray = this.getRow();
            Intrinsics.checkNotNull((Object)byArray);
            this.unfilteredRow = new byte[byArray.length];
            byte[] byArray2 = this.getRow();
            Intrinsics.checkNotNull((Object)byArray2);
            this.rowUnfilteredPrev = new byte[byArray2.length];
        }
        if (this.rowinfo.getRowNsubImg() == 0) {
            Intrinsics.checkNotNull((Object)this.unfilteredRow);
            ArrayUtilsKt.fill(this.unfilteredRow, (byte)0);
        }
        Intrinsics.checkNotNull((Object)this.unfilteredRow);
        byte[] tmp = this.unfilteredRow;
        this.unfilteredRow = this.rowUnfilteredPrev;
        this.rowUnfilteredPrev = tmp;
        byte[] byArray = this.getRow();
        Intrinsics.checkNotNull((Object)byArray);
        byte ftn = byArray[0];
        if (!FilterType.Companion.isValidStandard(ftn)) {
            throw new PngjInputException("Filter type " + ftn + " invalid");
        }
        FilterType ft = FilterType.Companion.getByVal(ftn);
        int[] nArray = this.filterUseStat;
        int n = nArray[ftn];
        nArray[ftn] = n + 1;
        Intrinsics.checkNotNull((Object)this.unfilteredRow);
        byte[] byArray3 = this.getRow();
        Intrinsics.checkNotNull((Object)byArray3);
        this.unfilteredRow[0] = byArray3[0];
        switch (WhenMappings.$EnumSwitchMapping$0[ft.ordinal()]) {
            case 1: {
                this.unfilterRowNone(nbytes);
                break;
            }
            case 2: {
                this.unfilterRowSub(nbytes);
                break;
            }
            case 3: {
                this.unfilterRowUp(nbytes);
                break;
            }
            case 4: {
                this.unfilterRowAverage(nbytes);
                break;
            }
            case 5: {
                this.unfilterRowPaeth(nbytes);
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + ftn + " not implemented");
            }
        }
    }

    private final void unfilterRowAverage(int nbytes) {
        int x = 0;
        int j = 1 - this.imgInfo.getBytesPixel();
        int i = 1;
        while (i <= nbytes) {
            int n;
            if (j > 0) {
                Intrinsics.checkNotNull((Object)this.unfilteredRow);
                n = this.unfilteredRow[j] & 0xFF;
            } else {
                n = 0;
            }
            x = n;
            Intrinsics.checkNotNull((Object)this.unfilteredRow);
            byte[] byArray = this.getRow();
            Intrinsics.checkNotNull((Object)byArray);
            byte by = byArray[i];
            Intrinsics.checkNotNull((Object)this.rowUnfilteredPrev);
            this.unfilteredRow[i] = (byte)(by + (x + (this.rowUnfilteredPrev[i] & 0xFF)) / 2);
            ++i;
            ++j;
        }
    }

    private final void unfilterRowNone(int nbytes) {
        int i = 1;
        if (i <= nbytes) {
            while (true) {
                Intrinsics.checkNotNull((Object)this.unfilteredRow);
                byte[] byArray = this.getRow();
                Intrinsics.checkNotNull((Object)byArray);
                this.unfilteredRow[i] = byArray[i];
                if (i == nbytes) break;
                ++i;
            }
        }
    }

    private final void unfilterRowPaeth(int nbytes) {
        int x = 0;
        int y = 0;
        int j = 1 - this.imgInfo.getBytesPixel();
        int i = 1;
        while (i <= nbytes) {
            int n;
            int n2;
            if (j > 0) {
                Intrinsics.checkNotNull((Object)this.unfilteredRow);
                n2 = this.unfilteredRow[j] & 0xFF;
            } else {
                n2 = x = 0;
            }
            if (j > 0) {
                Intrinsics.checkNotNull((Object)this.rowUnfilteredPrev);
                n = this.rowUnfilteredPrev[j] & 0xFF;
            } else {
                n = 0;
            }
            y = n;
            Intrinsics.checkNotNull((Object)this.unfilteredRow);
            byte[] byArray = this.getRow();
            Intrinsics.checkNotNull((Object)byArray);
            byte by = byArray[i];
            Intrinsics.checkNotNull((Object)this.rowUnfilteredPrev);
            this.unfilteredRow[i] = (byte)(by + PngHelperInternal.INSTANCE.filterPaethPredictor(x, this.rowUnfilteredPrev[i] & 0xFF, y));
            ++i;
            ++j;
        }
    }

    private final void unfilterRowSub(int nbytes) {
        int i;
        for (i = 1; i <= this.imgInfo.getBytesPixel(); ++i) {
            Intrinsics.checkNotNull((Object)this.unfilteredRow);
            byte[] byArray = this.getRow();
            Intrinsics.checkNotNull((Object)byArray);
            this.unfilteredRow[i] = byArray[i];
        }
        int j = 1;
        i = this.imgInfo.getBytesPixel() + 1;
        while (i <= nbytes) {
            Intrinsics.checkNotNull((Object)this.unfilteredRow);
            byte[] byArray = this.getRow();
            Intrinsics.checkNotNull((Object)byArray);
            byte by = byArray[i];
            Intrinsics.checkNotNull((Object)this.unfilteredRow);
            this.unfilteredRow[i] = (byte)(by + this.unfilteredRow[j]);
            ++i;
            ++j;
        }
    }

    private final void unfilterRowUp(int nbytes) {
        int i = 1;
        if (i <= nbytes) {
            while (true) {
                Intrinsics.checkNotNull((Object)this.unfilteredRow);
                byte[] byArray = this.getRow();
                Intrinsics.checkNotNull((Object)byArray);
                byte by = byArray[i];
                Intrinsics.checkNotNull((Object)this.rowUnfilteredPrev);
                this.unfilteredRow[i] = (byte)(by + this.rowUnfilteredPrev[i]);
                if (i == nbytes) break;
                ++i;
            }
        }
    }

    @Override
    protected void preProcessRow() {
        super.preProcessRow();
        this.rowinfo.update(this.getRown());
        this.unfilterRow();
        Intrinsics.checkNotNull((Object)this.unfilteredRow);
        this.rowinfo.updateBuf(this.unfilteredRow, this.rowinfo.getBytesRow() + 1);
    }

    @Override
    protected int processRowCallback() {
        return this.advanceToNextRow();
    }

    public final int advanceToNextRow() {
        boolean more;
        int bytesNextRow;
        int n = this.deinterlacer == null ? (this.getRown() >= this.imgInfo.getRows() - 1 ? 0 : this.imgInfo.getBytesPerRow() + 1) : (bytesNextRow = (more = this.deinterlacer.nextRow()) ? this.deinterlacer.getBytesToRead() + 1 : 0);
        if (!this.callbackMode) {
            this.prepareForNextRow(bytesNextRow);
        }
        return bytesNextRow;
    }

    @Override
    public boolean isRowReady() {
        return !this.isWaitingForMoreInput();
    }

    public final void updateCrcs(Checksum ... idatCrcs) {
        Intrinsics.checkNotNullParameter((Object)idatCrcs, (String)"idatCrcs");
        int n = idatCrcs.length;
        for (int i = 0; i < n; ++i) {
            Checksum idatCrca;
            Checksum checksum = idatCrca = idatCrcs[i];
            if (checksum == null) continue;
            Intrinsics.checkNotNull((Object)this.unfilteredRow);
            checksum.update(this.unfilteredRow, 1, this.getRowFilled() - 1);
        }
    }

    @Override
    public void close() {
        super.close();
        this.unfilteredRow = null;
        this.rowUnfilteredPrev = null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterType.values().length];
            try {
                nArray[FilterType.FILTER_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_SUB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_AVERAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_PAETH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

