/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

@AutoService(value={Function.class})
public class IterationCounter
extends AbstractFunction
implements ThreadListener {
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__counter";
    private Object[] variables;
    private final AtomicInteger globalCounter = new AtomicInteger();
    private final ThreadLocal<AtomicInteger> perThreadInt = ThreadLocal.withInitial(AtomicInteger::new);

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        boolean perThread = Boolean.parseBoolean(((CompoundVariable)this.variables[0]).execute());
        String varName = "";
        if (this.variables.length >= 2) {
            varName = ((CompoundVariable)this.variables[1]).execute().trim();
        }
        String counterString = "";
        counterString = perThread ? String.valueOf(this.perThreadInt.get().addAndGet(1)) : String.valueOf(this.globalCounter.addAndGet(1));
        if (vars != null && varName.length() > 0) {
            vars.put(varName, counterString);
        }
        return counterString;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.variables = parameters.toArray();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public void threadStarted() {
    }

    public void threadFinished() {
        this.perThreadInt.remove();
    }

    static {
        desc.add(JMeterUtils.getResString((String)"iteration_counter_arg_1"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
    }
}

