/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.curl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public interface ArgumentHolder {
    public String getName();

    public Map<String, String> getMetadata();

    default public String getContentType() {
        return this.getMetadata().get("type");
    }

    default public boolean hasContenType() {
        return this.getMetadata().containsKey("type");
    }

    public static Pair<String, Map<String, String>> parse(String name) {
        if (name.contains(";")) {
            String[] parts = name.split(";");
            String realName = parts[0];
            HashMap<String, String> metadata = new HashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                String[] typeParts = parts[i].split("\\s*=\\s*", 2);
                metadata.put(typeParts[0].toLowerCase(Locale.US), typeParts[1]);
            }
            return Pair.of((Object)realName, metadata);
        }
        return Pair.of((Object)name, Collections.emptyMap());
    }
}

