/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.graphics.Animator;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class DarkTreeExpansionAnimationListener
implements TreeExpansionListener {
    private final JTree tree;
    private final TreeStateAnimator animator;

    public DarkTreeExpansionAnimationListener(JTree tree) {
        this.tree = tree;
        this.animator = new TreeStateAnimator();
        this.animator.setEnabled(UIManager.getBoolean("Tree.iconAnimations"));
        tree.addTreeExpansionListener(this);
    }

    public void install() {
        this.tree.addTreeExpansionListener(this);
    }

    public void uninstall() {
        this.animator.dispose();
        this.tree.removeTreeExpansionListener(this);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.startAnimation(event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.startAnimation(event.getPath());
    }

    public void startAnimation(TreePath path) {
        if (!this.animator.isEnabled()) {
            return;
        }
        this.animator.state = 0.0f;
        this.animator.path = path;
        this.animator.animationRow = this.tree.getRowForPath(path);
        boolean running = this.animator.isRunning();
        this.animator.suspend();
        if (running) {
            this.animator.resume(this.animator.getTotalFrames(), false);
        }
        this.animator.resume(0, false, this.tree);
    }

    public TreePath getAnimationPath() {
        return this.animator.path;
    }

    public float getAnimationState() {
        return this.animator.state;
    }

    protected class TreeStateAnimator
    extends Animator {
        private static final int DURATION = 60;
        private static final int RESOLUTION = 10;
        private TreePath path;
        private float state;
        private int animationRow;

        public TreeStateAnimator() {
            super(6, 60, 0);
        }

        private void repaint() {
            if (this.animationRow >= 0) {
                Rectangle bounds = DarkTreeExpansionAnimationListener.this.tree.getRowBounds(this.animationRow);
                bounds.x = 0;
                bounds.width = DarkTreeExpansionAnimationListener.this.tree.getWidth();
                DarkTreeExpansionAnimationListener.this.tree.paintImmediately(bounds);
            }
        }

        @Override
        public void paintNow(float fraction) {
            this.state = fraction;
            this.repaint();
        }

        @Override
        protected void paintCycleEnd() {
            super.paintCycleEnd();
            this.state = 1.0f;
            this.repaint();
            this.animationRow = -1;
        }
    }
}

