/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.components.color.PopupColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DarkColorTableCellRendererEditor
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private final JComponent colorComp = new JPanel();
    private Color savedColor;

    public DarkColorTableCellRendererEditor() {
        this.colorComp.setOpaque(true);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof Color)) {
            this.cancelCellEditing();
            return table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }
        this.changeColor((Color)value);
        SwingUtilities.invokeLater(() -> PopupColorChooser.showColorChooser(this.colorComp, this.savedColor, this::changeColor, this::stopCellEditing, true));
        return this.colorComp;
    }

    private void changeColor(Color color) {
        if (color != null) {
            this.savedColor = color;
            this.colorComp.setBackground(ColorUtil.stripUIResource((Color)color, (boolean)false));
        }
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return this.savedColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.changeColor((Color)value);
        return this.colorComp;
    }
}

