/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import jodd.util.concurrent.ThreadFactoryBuilder;

public class Futures {
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, ThreadFactoryBuilder.create().setDaemon(true).setNameFormat("failAfter-%d").get());

    public static <T> CompletableFuture<T> failAfter(long duration) {
        CompletableFuture promise = new CompletableFuture();
        SCHEDULER.schedule(() -> {
            TimeoutException ex = new TimeoutException("Timeout after " + duration);
            return promise.completeExceptionally(ex);
        }, duration, TimeUnit.MILLISECONDS);
        return promise;
    }

    public static <T> CompletableFuture<T> failAfter(Duration duration) {
        return Futures.failAfter(duration.toMillis());
    }

    public static <T> CompletableFuture<T> within(CompletableFuture<T> future, Duration duration) {
        CompletableFuture<T> timeout = Futures.failAfter(duration);
        return future.applyToEither((CompletionStage)timeout, Function.identity());
    }

    public static <T> CompletableFuture<T> within(CompletableFuture<T> future, long duration) {
        CompletableFuture<T> timeout = Futures.failAfter(duration);
        return future.applyToEither((CompletionStage)timeout, Function.identity());
    }
}

