/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ChangeListener;
import com.mongodb.Cluster;
import com.mongodb.ClusterDescription;
import com.mongodb.ClusterDescriptionChangedEvent;
import com.mongodb.ClusterEvent;
import com.mongodb.ClusterListener;
import com.mongodb.ClusterSettings;
import com.mongodb.ClusterType;
import com.mongodb.ClusterableServer;
import com.mongodb.ClusterableServerFactory;
import com.mongodb.Connection;
import com.mongodb.Loggers;
import com.mongodb.MongoIncompatibleDriverException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.Server;
import com.mongodb.ServerAddress;
import com.mongodb.ServerDescription;
import com.mongodb.ServerSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.bson.util.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseCluster
implements Cluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final AtomicReference<CountDownLatch> phase = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final ClusterableServerFactory serverFactory;
    private final ThreadLocal<Random> random = new ThreadLocal();
    private final String clusterId;
    private final ClusterSettings settings;
    private final ClusterListener clusterListener;
    private volatile boolean isClosed;
    private volatile ClusterDescription description;

    public BaseCluster(String clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, ClusterListener clusterListener) {
        this.clusterId = Assertions.notNull("clusterId", clusterId);
        this.settings = Assertions.notNull("settings", settings);
        this.serverFactory = Assertions.notNull("serverFactory", serverFactory);
        this.clusterListener = Assertions.notNull("clusterListener", clusterListener);
        clusterListener.clusterOpened(new ClusterEvent(clusterId));
    }

    @Override
    public Server getServer(ServerSelector serverSelector, long maxWaitTime, TimeUnit timeUnit) {
        Assertions.isTrue("open", !this.isClosed());
        try {
            CountDownLatch currentPhase = this.phase.get();
            ClusterDescription curDescription = this.description;
            List<ServerDescription> serverDescriptions = serverSelector.choose(curDescription);
            boolean selectionFailureLogged = false;
            long startTimeNanos = System.nanoTime();
            long endTimeNanos = startTimeNanos + TimeUnit.NANOSECONDS.convert(maxWaitTime, timeUnit);
            long curTimeNanos = startTimeNanos;
            while (true) {
                ClusterableServer server;
                this.throwIfIncompatible(curDescription);
                if (!serverDescriptions.isEmpty() && (server = this.getRandomServer(new ArrayList<ServerDescription>(serverDescriptions))) != null) {
                    return new WrappedServer(server);
                }
                if (curTimeNanos > endTimeNanos) {
                    throw new MongoTimeoutException(String.format("Timed out after %d ms while waiting for a server that matches %s. Client view of cluster state is %s", TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit), serverSelector, curDescription.getShortDescription()));
                }
                if (!selectionFailureLogged) {
                    LOGGER.info(String.format("No server chosen by %s from cluster description %s. Waiting for %d ms before timing out", serverSelector, curDescription, TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit)));
                    selectionFailureLogged = true;
                }
                this.connect();
                currentPhase.await(Math.min(endTimeNanos - curTimeNanos, this.serverFactory.getSettings().getHeartbeatConnectRetryFrequency(TimeUnit.NANOSECONDS)), TimeUnit.NANOSECONDS);
                curTimeNanos = System.nanoTime();
                currentPhase = this.phase.get();
                curDescription = this.description;
                serverDescriptions = serverSelector.choose(curDescription);
            }
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException(String.format("Interrupted while waiting for a server that matches %s ", serverSelector), e);
        }
    }

    @Override
    public ClusterDescription getDescription(long maxWaitTime, TimeUnit timeUnit) {
        Assertions.isTrue("open", !this.isClosed());
        try {
            CountDownLatch currentPhase = this.phase.get();
            ClusterDescription curDescription = this.description;
            boolean selectionFailureLogged = false;
            long startTimeNanos = System.nanoTime();
            long endTimeNanos = startTimeNanos + TimeUnit.NANOSECONDS.convert(maxWaitTime, timeUnit);
            long curTimeNanos = startTimeNanos;
            while (curDescription.getType() == ClusterType.Unknown) {
                if (curTimeNanos > endTimeNanos) {
                    throw new MongoTimeoutException(String.format("Timed out after %d ms while waiting to connect. Client view of cluster state is %s", TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit), curDescription.getShortDescription()));
                }
                if (!selectionFailureLogged) {
                    LOGGER.info(String.format("Cluster description not yet available. Waiting for %d ms before timing out", TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit)));
                    selectionFailureLogged = true;
                }
                this.connect();
                currentPhase.await(Math.min(endTimeNanos - curTimeNanos, this.serverFactory.getSettings().getHeartbeatConnectRetryFrequency(TimeUnit.NANOSECONDS)), TimeUnit.NANOSECONDS);
                curTimeNanos = System.nanoTime();
                currentPhase = this.phase.get();
                curDescription = this.description;
            }
            return curDescription;
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException(String.format("Interrupted while waiting to connect", new Object[0]), e);
        }
    }

    public ClusterSettings getSettings() {
        return this.settings;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.isClosed = true;
            this.phase.get().countDown();
            this.clusterListener.clusterClosed(new ClusterEvent(this.clusterId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected abstract ClusterableServer getServer(ServerAddress var1);

    protected abstract void connect();

    protected synchronized void updateDescription(ClusterDescription newDescription) {
        LOGGER.fine(String.format("Updating cluster description to  %s", newDescription.getShortDescription()));
        this.description = newDescription;
        CountDownLatch current = this.phase.getAndSet(new CountDownLatch(1));
        current.countDown();
    }

    protected void fireChangeEvent() {
        this.clusterListener.clusterDescriptionChanged(new ClusterDescriptionChangedEvent(this.clusterId, this.description));
    }

    ClusterDescription getCurrentDescription() {
        return this.description;
    }

    private ClusterableServer getRandomServer(List<ServerDescription> serverDescriptions) {
        while (!serverDescriptions.isEmpty()) {
            int serverPos = this.getRandom().nextInt(serverDescriptions.size());
            ClusterableServer server = this.getServer(serverDescriptions.get(serverPos).getAddress());
            if (server != null) {
                return server;
            }
            serverDescriptions.remove(serverPos);
        }
        return null;
    }

    private void throwIfIncompatible(ClusterDescription curDescription) {
        if (!curDescription.isCompatibleWithDriver()) {
            throw new MongoIncompatibleDriverException(String.format("This version of the driver is not compatible with one or more of the servers to which it is connected: %s", curDescription));
        }
    }

    private Random getRandom() {
        Random result = this.random.get();
        if (result == null) {
            result = new Random();
            this.random.set(result);
        }
        return result;
    }

    protected ClusterableServer createServer(ServerAddress serverAddress, ChangeListener<ServerDescription> serverStateListener) {
        ClusterableServer server = this.serverFactory.create(serverAddress);
        server.addChangeListener(serverStateListener);
        return server;
    }

    private static final class WrappedServer
    implements Server {
        private final ClusterableServer wrapped;

        public WrappedServer(ClusterableServer server) {
            this.wrapped = server;
        }

        public ServerDescription getDescription() {
            return this.wrapped.getDescription();
        }

        public Connection getConnection(long maxWaitTime, TimeUnit timeUnit) {
            return this.wrapped.getConnection(maxWaitTime, timeUnit);
        }

        public void invalidate() {
            this.wrapped.invalidate();
        }
    }
}

