/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class TextAreaTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = 240L;
    protected JTextArea editorComponent = new JTextArea();
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;

    public TextAreaTableCellEditor() {
        this.editorComponent.setRows(3);
        this.clickCountToStart = 2;
        this.delegate = new EditorDelegate(){
            private static final long serialVersionUID = 240L;

            @Override
            public void setValue(Object value) {
                TextAreaTableCellEditor.this.editorComponent.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return TextAreaTableCellEditor.this.editorComponent.getText();
            }
        };
        this.editorComponent.addFocusListener(this.delegate);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
        this.delegate.setValue(stringValue);
        return new JScrollPane(this.editorComponent);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value);
        return new JScrollPane(this.editorComponent);
    }

    protected class EditorDelegate
    implements FocusListener,
    Serializable {
        private static final long serialVersionUID = 240L;
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= TextAreaTableCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            TextAreaTableCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            TextAreaTableCellEditor.this.fireEditingCanceled();
        }

        public void actionPerformed(ActionEvent e) {
            TextAreaTableCellEditor.this.stopCellEditing();
        }

        public void itemStateChanged(ItemEvent e) {
            TextAreaTableCellEditor.this.stopCellEditing();
        }

        @Override
        public void focusLost(FocusEvent ev) {
            TextAreaTableCellEditor.this.stopCellEditing();
        }

        @Override
        public void focusGained(FocusEvent ev) {
        }
    }
}

