/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.Load;
import org.apache.jmeter.gui.action.template.Template;
import org.apache.jmeter.gui.action.template.TemplateManager;
import org.apache.jmeter.swing.HtmlPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.TemplateUtil;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JFactory;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.gui.JLabeledTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTemplatesDialog
extends JDialog
implements ChangeListener,
ActionListener,
HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private static final int MINIMAL_BOX_WIDTH = 500;
    private static final int MINIMAL_BOX_HEIGHT = 300;
    private static final Logger log = LoggerFactory.getLogger(SelectTemplatesDialog.class);
    private final JLabeledChoice templateList = new JLabeledChoice(JMeterUtils.getResString("template_choose"), false);
    private final HtmlPane helpDoc = new HtmlPane();
    private final JButton reloadTemplateButton = new JButton(JMeterUtils.getResString("template_reload"));
    private final JButton applyTemplateButton = new JButton();
    private final JButton cancelButton = new JButton(JMeterUtils.getResString("cancel"));
    private final JButton previous = new JButton(JMeterUtils.getResString("previous"));
    private final JButton validateButton = new JButton();
    private final Map<String, JLabeledTextField> parametersTextFields = new LinkedHashMap<String, JLabeledTextField>();
    private final JPanel actionBtnBar = new JPanel(new FlowLayout());

    public SelectTemplatesDialog() {
        super((Frame)null, JMeterUtils.getResString("template_title"), true);
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -6543764044868772971L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTemplatesDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -3661361497864527363L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectTemplatesDialog.this.checkDirtyAndLoad(actionEvent);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void checkDirtyAndLoad(ActionEvent actionEvent) throws HeadlessException {
        String selectedTemplate = this.templateList.getText();
        Template template = TemplateManager.getInstance().getTemplateByName(selectedTemplate);
        if (template == null) {
            return;
        }
        this.templateList.setValues(TemplateManager.getInstance().getTemplateNames());
        boolean isTestPlan = template.isTestPlan();
        if (isTestPlan && !SelectTemplatesDialog.checkDirty(actionEvent)) {
            return;
        }
        ActionRouter.getInstance().doActionNow(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), "stop_thread"));
        File parent = template.getParent();
        File fileToCopy = parent != null ? new File(parent, template.getFileName()) : new File(JMeterUtils.getJMeterHome(), template.getFileName());
        this.replaceTemplateParametersAndLoad(actionEvent, template, isTestPlan, fileToCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceTemplateParametersAndLoad(ActionEvent actionEvent, Template template, boolean isTestPlan, File templateFile) {
        File temporaryGeneratedFile = null;
        try {
            if (template.getParameters() != null && !template.getParameters().isEmpty()) {
                File jmxFile = new File(templateFile.getAbsolutePath());
                Map<String, String> userParameters = this.getUserParameters();
                Configuration templateCfg = TemplateUtil.getTemplateConfig();
                try {
                    templateFile = temporaryGeneratedFile = File.createTempFile(template.getName(), ".output");
                    TemplateUtil.processTemplate(jmxFile, temporaryGeneratedFile, templateCfg, userParameters);
                }
                catch (TemplateException | IOException ex) {
                    log.error("Error generating output file {} from template {}", new Object[]{temporaryGeneratedFile, jmxFile, ex});
                    if (temporaryGeneratedFile != null && !temporaryGeneratedFile.delete()) {
                        log.warn("Could not delete generated output file {} from template {}", (Object)temporaryGeneratedFile, (Object)templateFile);
                    }
                    return;
                }
            }
            Load.loadProjectFile(actionEvent, templateFile, !isTestPlan, false);
            this.dispose();
        }
        finally {
            if (temporaryGeneratedFile != null && !temporaryGeneratedFile.delete()) {
                log.warn("Could not delete generated output file {} from template {}", (Object)temporaryGeneratedFile, (Object)templateFile);
            }
        }
    }

    private static boolean checkDirty(ActionEvent actionEvent) {
        ActionRouter.getInstance().doActionNow(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), "check_dirty"));
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (guiPackage.isDirty()) {
            int response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("cancel_new_from_template"), JMeterUtils.getResString("template_load?"), 1, 3);
            if (response == 0) {
                ActionRouter.getInstance().doActionNow(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), "save"));
                return true;
            }
            if (response == -1 || response == 2) {
                return false;
            }
        }
        return true;
    }

    private Map<String, String> getUserParameters() {
        LinkedHashMap<String, String> userParameters = new LinkedHashMap<String, String>();
        for (Map.Entry<String, JLabeledTextField> entry : this.parametersTextFields.entrySet()) {
            userParameters.put(entry.getKey(), entry.getValue().getText());
        }
        return userParameters;
    }

    private void init() {
        this.templateList.setValues(TemplateManager.getInstance().getTemplateNames());
        this.templateList.addChangeListener((ChangeListener)this);
        this.reloadTemplateButton.addActionListener(this);
        JFactory.small((JButton)this.reloadTemplateButton);
        this.helpDoc.setContentType("text/html");
        this.helpDoc.setEditable(false);
        this.helpDoc.addHyperlinkListener(this);
        this.applyTemplateButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.previous.addActionListener(this);
        this.validateButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SelectTemplatesDialog.this.resetJDialog(false);
                SelectTemplatesDialog.this.dispose();
            }
        });
        this.setContentPane(this.templateSelectionPanel());
        this.pack();
        this.setMinimumSize(new Dimension(500, 300));
        ComponentUtil.centerComponentInWindow((Component)this, (int)50);
        this.populateTemplatePage();
    }

    private JPanel templateSelectionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scroller = new JScrollPane();
        scroller.setViewportView(this.helpDoc);
        JPanel templateBar = new JPanel(new BorderLayout());
        templateBar.add((Component)this.templateList, "Center");
        JPanel reloadBtnBar = new JPanel();
        reloadBtnBar.add(this.reloadTemplateButton);
        templateBar.add((Component)reloadBtnBar, "East");
        this.actionBtnBar.add(this.applyTemplateButton);
        this.actionBtnBar.add(this.cancelButton);
        panel.add((Component)templateBar, "North");
        panel.add((Component)scroller, "Center");
        panel.add((Component)this.actionBtnBar, "South");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelButton) {
            this.resetJDialog(false);
            this.dispose();
        } else if (source == this.applyTemplateButton) {
            String selectedTemplate = this.templateList.getText();
            Template template = TemplateManager.getInstance().getTemplateByName(selectedTemplate);
            if (SelectTemplatesDialog.hasParameters(template)) {
                this.setContentPane(this.configureParametersPanel(template.getParameters()));
                this.revalidate();
            } else {
                this.checkDirtyAndLoad(e);
            }
        } else if (source == this.reloadTemplateButton) {
            this.resetJDialog(true);
        } else if (source == this.previous) {
            this.resetJDialog(false);
        } else if (source == this.validateButton) {
            this.checkDirtyAndLoad(e);
            this.resetJDialog(false);
        }
    }

    private static boolean hasParameters(Template template) {
        return template.getParameters() != null && !template.getParameters().isEmpty();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.populateTemplatePage();
    }

    private void resetJDialog(boolean reloadTemplates) {
        if (reloadTemplates) {
            TemplateManager.getInstance().reset();
        }
        this.templateList.setValues(TemplateManager.getInstance().getTemplateNames());
        this.setContentPane(this.templateSelectionPanel());
        this.revalidate();
    }

    private void populateTemplatePage() {
        String selectedTemplate = this.templateList.getText();
        Template template = TemplateManager.getInstance().getTemplateByName(selectedTemplate);
        this.helpDoc.setText(template.getDescription());
        this.applyTemplateButton.setText(template.isTestPlan() ? JMeterUtils.getResString("template_create_from") : JMeterUtils.getResString("template_merge_from"));
        this.validateButton.setText(template.isTestPlan() ? JMeterUtils.getResString("template_create_from") : JMeterUtils.getResString("template_merge_from"));
    }

    private JPanel configureParametersPanel(Map<String, String> parameters) {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new FlowLayout());
        JLabel label = new JLabel(JMeterUtils.getResString("template_fill_parameters"));
        label.setPreferredSize(new Dimension(150, 35));
        northPanel.add(label);
        panel.add((Component)northPanel, "North");
        this.parametersTextFields.clear();
        GridBagConstraints gbc = new GridBagConstraints();
        SelectTemplatesDialog.initConstraints(gbc);
        int parameterCount = 0;
        JPanel gridbagpanel = new JPanel(new GridBagLayout());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            JLabeledTextField paramLabel = new JLabeledTextField(key + " : ");
            paramLabel.setText(value);
            this.parametersTextFields.put(key, paramLabel);
            gbc.gridy = parameterCount++;
            List listedParamLabel = paramLabel.getComponentList();
            gridbagpanel.add((Component)listedParamLabel.get(0), gbc.clone());
            gbc.gridx = 1;
            gridbagpanel.add((Component)listedParamLabel.get(1), gbc.clone());
            gbc.gridx = 0;
        }
        JPanel actionBtnBarParameterPanel = new JPanel(new FlowLayout());
        actionBtnBarParameterPanel.add(this.validateButton);
        actionBtnBarParameterPanel.add(this.cancelButton);
        actionBtnBarParameterPanel.add(this.previous);
        JScrollPane scroller = new JScrollPane(gridbagpanel);
        panel.add((Component)scroller, "Center");
        panel.add((Component)actionBtnBarParameterPanel, "South");
        return panel;
    }

    private static void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(e.getURL().toURI());
            }
            catch (Exception ex) {
                log.error("Error opening URL in browser: {}", (Object)e.getURL());
            }
        }
    }
}

