/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.Searcher;

public class RawTextSearcher
implements Searcher {
    private final boolean caseSensitive;
    private final String textToSearch;

    public RawTextSearcher(boolean caseSensitive, String textToSearch) {
        this.caseSensitive = caseSensitive;
        this.textToSearch = textToSearch;
    }

    @Override
    public boolean search(List<String> textTokens) {
        return textTokens.stream().filter(StringUtils::isNotEmpty).anyMatch(token -> this.caseSensitive ? token.contains(this.textToSearch) : StringUtils.containsAnyIgnoreCase((CharSequence)token, (CharSequence[])new CharSequence[]{this.textToSearch}));
    }

    public String toString() {
        return "RawTextSearcher [caseSensitive=" + this.caseSensitive + ", textToSearch=" + this.textToSearch + "]";
    }
}

