/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.google.auto.service.AutoService;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.action.TreeNodeNamingPolicy;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Command.class})
public class ApplyNamingConvention
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(ApplyNamingConvention.class);
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode[] currentNodes = guiPackage.getTreeListener().getSelectedNodes();
        ArrayList<JMeterTreeNode> filteredNodes = new ArrayList<JMeterTreeNode>();
        for (JMeterTreeNode jMeterTreeNode : currentNodes) {
            if (jMeterTreeNode.getUserObject() instanceof Controller) {
                filteredNodes.add(jMeterTreeNode);
                continue;
            }
            log.warn("Applying naming policy, selected node {}\u00a0is not a Controller, will ignore it", (Object)jMeterTreeNode.getName());
        }
        try {
            for (JMeterTreeNode currentNode : filteredNodes) {
                ApplyNamingConvention.applyNamingPolicyToCurrentNode(guiPackage, currentNode);
            }
            GuiPackage.getInstance().getMainFrame().repaint();
        }
        catch (Exception err) {
            Toolkit.getDefaultToolkit().beep();
            log.error("Failed to apply naming policy", (Throwable)err);
            JMeterUtils.reportErrorToUser("Failed to apply naming policy", err);
        }
    }

    private static void applyNamingPolicyToCurrentNode(GuiPackage guiPackage, JMeterTreeNode currentNode) {
        TreeNodeNamingPolicy namingPolicy = guiPackage.getNamingPolicy();
        guiPackage.updateCurrentNode();
        Enumeration<TreeNode> enumeration = currentNode.children();
        int index = 0;
        namingPolicy.resetState(currentNode);
        while (enumeration.hasMoreElements()) {
            JMeterTreeNode childNode = (JMeterTreeNode)enumeration.nextElement();
            namingPolicy.rename(currentNode, childNode, index);
            ++index;
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("Apply Naming Convention");
    }
}

