/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.util.ScopePanel;

public abstract class AbstractScopedJMeterGuiComponent
extends AbstractJMeterGuiComponent {
    private static final long serialVersionUID = 240L;
    private ScopePanel scopePanel;

    @Override
    public void clearGui() {
        super.clearGui();
        if (this.scopePanel != null) {
            this.scopePanel.clearGui();
        }
    }

    @Override
    public JPopupMenu createPopupMenu() {
        return MenuFactory.getDefaultAssertionMenu();
    }

    protected JPanel createScopePanel() {
        return this.createScopePanel(false);
    }

    protected JPanel createScopePanel(boolean enableVariable) {
        return this.createScopePanel(enableVariable, true, true);
    }

    protected JPanel createScopePanel(boolean enableVariable, boolean enableParentAndSubsamples, boolean enableSubsamplesOnly) {
        this.scopePanel = new ScopePanel(enableVariable, enableParentAndSubsamples, enableSubsamplesOnly);
        return this.scopePanel;
    }

    protected void saveScopeSettings(AbstractScopedTestElement testElement) {
        if (this.scopePanel.isScopeParent()) {
            testElement.setScopeParent();
        } else if (this.scopePanel.isScopeChildren()) {
            testElement.setScopeChildren();
        } else if (this.scopePanel.isScopeAll()) {
            testElement.setScopeAll();
        } else if (this.scopePanel.isScopeVariable()) {
            testElement.setScopeVariable(this.scopePanel.getVariable());
        } else {
            throw new IllegalArgumentException("Unexpected scope panel state");
        }
    }

    protected void showScopeSettings(AbstractScopedTestElement testElement) {
        this.showScopeSettings(testElement, false);
    }

    protected void showScopeSettings(AbstractScopedTestElement testElement, boolean enableVariableButton) {
        String scope = testElement.fetchScope();
        if (testElement.isScopeParent(scope)) {
            this.scopePanel.setScopeParent(enableVariableButton);
        } else if (testElement.isScopeChildren(scope)) {
            this.scopePanel.setScopeChildren(enableVariableButton);
        } else if (testElement.isScopeAll(scope)) {
            this.scopePanel.setScopeAll(enableVariableButton);
        } else if (testElement.isScopeVariable(scope)) {
            this.scopePanel.setScopeVariable(testElement.getVariableName());
        } else {
            throw new IllegalArgumentException("Invalid scope: " + scope);
        }
    }
}

