/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.AxisBreaksProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.HorizontalAxisLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.VerticalAxisLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.BreakLabelsLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00102\u0006\u0010\r\u001a\u00020\u000eH$J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter;", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "domainRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "labelsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;)V", "getOrientation", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "axisLength", "", "toAxisMapper", "Lkotlin/Function1;", "toScaleMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "Companion", "plot-builder"})
public abstract class AxisLayouter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final DoubleSpan domainRange;
    @NotNull
    private final AxisLabelsLayout labelsLayout;

    public AxisLayouter(@NotNull Orientation orientation, @NotNull DoubleSpan domainRange, @NotNull AxisLabelsLayout labelsLayout) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)domainRange, (String)"domainRange");
        Intrinsics.checkNotNullParameter((Object)labelsLayout, (String)"labelsLayout");
        this.orientation = orientation;
        this.domainRange = domainRange;
        this.labelsLayout = labelsLayout;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final AxisLayoutInfo doLayout(double axisLength) {
        AxisLabelsLayoutInfo labelsInfo = this.labelsLayout.doLayout(axisLength, this.toAxisMapper(axisLength));
        ScaleBreaks scaleBreaks = labelsInfo.getBreaks();
        Intrinsics.checkNotNull((Object)scaleBreaks);
        ScaleBreaks axisBreaks = scaleBreaks;
        DoubleRectangle doubleRectangle = labelsInfo.getBounds();
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle labelsBounds = doubleRectangle;
        return new AxisLayoutInfo(axisLength, this.domainRange, this.orientation, axisBreaks, labelsBounds, labelsInfo.getLabelRotationAngle(), labelsInfo.getLabelHorizontalAnchor(), labelsInfo.getLabelVerticalAnchor(), labelsInfo.getLabelAdditionalOffsets(), BreakLabelsLayoutUtil.INSTANCE.textBounds(labelsBounds, this.labelsLayout.getTheme().tickLabelMargins(), this.orientation), labelsInfo.getLabelBoundsList());
    }

    @NotNull
    protected abstract Function1<Double, Double> toAxisMapper(double var1);

    @NotNull
    protected final ScaleMapper<Double> toScaleMapper(double axisLength) {
        return Mappers.INSTANCE.mul(this.domainRange, axisLength);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "breaksProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisBreaksProvider;", "geomAreaInsets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "trimLongValues", "", "text", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nAxisLayouter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxisLayouter.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 AxisLayouter.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/AxisLayouter$Companion\n*L\n69#1:114\n69#1:115,3\n91#1:118\n91#1:119,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AxisLayouter create(@NotNull Orientation orientation, @NotNull DoubleSpan axisDomain, @NotNull AxisBreaksProvider breaksProvider, @NotNull Insets geomAreaInsets, @NotNull AxisTheme theme) {
            AxisLabelsLayout axisLabelsLayout;
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
            Intrinsics.checkNotNullParameter((Object)breaksProvider, (String)"breaksProvider");
            Intrinsics.checkNotNullParameter((Object)geomAreaInsets, (String)"geomAreaInsets");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            if (orientation.isHorizontal()) {
                AxisLabelsLayout axisLabelsLayout2;
                if (breaksProvider.isFixedBreaks()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ScaleBreaks $this$create_u24lambda_u240 = breaksProvider.getFixedBreaks();
                    boolean bl = false;
                    Iterable iterable = $this$create_u24lambda_u240.getLabels();
                    Companion companion = Companion;
                    List list = $this$create_u24lambda_u240.getTransformedValues();
                    List list2 = $this$create_u24lambda_u240.getDomainValues();
                    boolean $i$f$map = false;
                    void var15_20 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(companion.trimLongValues((String)p0));
                    }
                    collection = (List)destination$iv$iv;
                    List list3 = collection;
                    List list4 = list;
                    List list5 = list2;
                    ScaleBreaks trimmedScaleBreaks = new ScaleBreaks(list5, list4, list3);
                    axisLabelsLayout2 = AxisLabelsLayout.Companion.horizontalFixedBreaks(orientation, axisDomain, trimmedScaleBreaks, geomAreaInsets, theme);
                } else {
                    axisLabelsLayout2 = AxisLabelsLayout.Companion.horizontalFlexBreaks(orientation, axisDomain, breaksProvider, theme);
                }
                AxisLabelsLayout labelsLayout = axisLabelsLayout2;
                return new HorizontalAxisLayouter(orientation, axisDomain, labelsLayout);
            }
            if (breaksProvider.isFixedBreaks()) {
                Collection<String> collection;
                ScaleBreaks $this$create_u24lambda_u242 = breaksProvider.getFixedBreaks();
                boolean bl = false;
                Iterable $this$map$iv = $this$create_u24lambda_u242.getLabels();
                Companion companion = Companion;
                List list = $this$create_u24lambda_u242.getTransformedValues();
                List list6 = $this$create_u24lambda_u242.getDomainValues();
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String p0 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(companion.trimLongValues(p0));
                }
                collection = (List)destination$iv$iv;
                List list7 = collection;
                List list8 = list;
                List list9 = list6;
                ScaleBreaks trimmedScaleBreaks = new ScaleBreaks(list9, list8, list7);
                axisLabelsLayout = AxisLabelsLayout.Companion.verticalFixedBreaks(orientation, axisDomain, trimmedScaleBreaks, theme);
            } else {
                axisLabelsLayout = AxisLabelsLayout.Companion.verticalFlexBreaks(orientation, axisDomain, breaksProvider, theme);
            }
            AxisLabelsLayout labelsLayout = axisLabelsLayout;
            return new VerticalAxisLayouter(orientation, axisDomain, labelsLayout);
        }

        private final String trimLongValues(String text) {
            return text.length() <= 20 ? text : StringsKt.take((String)text, (int)20) + "..";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

