/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.config.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="ldap_sample_title")
public class LdapConfigGui
extends AbstractConfigGui
implements ItemListener {
    private static final long serialVersionUID = 241L;
    private final JTextField rootdn = new JTextField(20);
    private final JTextField searchbase = new JTextField(20);
    private final JTextField searchfilter = new JTextField(20);
    private final JTextField delete = new JTextField(20);
    private final JTextField add = new JTextField(20);
    private final JTextField modify = new JTextField(20);
    private final JTextField servername = new JTextField(20);
    private final JTextField port = new JTextField(20);
    private final JCheckBox userDefined = new JCheckBox(JMeterUtils.getResString((String)"user_defined_test"));
    private final JRadioButton addTest = new JRadioButton(JMeterUtils.getResString((String)"add_test"));
    private final JRadioButton modifyTest = new JRadioButton(JMeterUtils.getResString((String)"modify_test"));
    private final JRadioButton deleteTest = new JRadioButton(JMeterUtils.getResString((String)"delete_test"));
    private final JRadioButton searchTest = new JRadioButton(JMeterUtils.getResString((String)"search_test"));
    private final ButtonGroup bGroup = new ButtonGroup();
    private boolean displayName = true;
    private final ArgumentsPanel tableAddPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"add_test"));
    private final ArgumentsPanel tableModifyPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"modify_test"));
    private JPanel cards;

    public LdapConfigGui() {
        this(true);
    }

    public LdapConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getLabelResource() {
        return "ldap_sample_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.servername.setText(element.getPropertyAsString("servername"));
        this.port.setText(element.getPropertyAsString("port"));
        this.rootdn.setText(element.getPropertyAsString("rootdn"));
        CardLayout cl = (CardLayout)this.cards.getLayout();
        String testType = element.getPropertyAsString("test");
        if (testType.equals("add")) {
            this.addTest.setSelected(true);
            this.add.setText(element.getPropertyAsString("base_entry_dn"));
            this.tableAddPanel.configure((TestElement)element.getProperty("arguments").getObjectValue());
            cl.show(this.cards, "Add");
        } else if (testType.equals("modify")) {
            this.modifyTest.setSelected(true);
            this.modify.setText(element.getPropertyAsString("base_entry_dn"));
            this.tableModifyPanel.configure((TestElement)element.getProperty("arguments").getObjectValue());
            cl.show(this.cards, "Modify");
        } else if (testType.equals("delete")) {
            this.deleteTest.setSelected(true);
            this.delete.setText(element.getPropertyAsString("delete"));
            cl.show(this.cards, "Delete");
        } else if (testType.equals("search")) {
            this.searchTest.setSelected(true);
            this.searchbase.setText(element.getPropertyAsString("search"));
            this.searchfilter.setText(element.getPropertyAsString("searchfilter"));
            cl.show(this.cards, "Search");
        }
        if (element.getPropertyAsBoolean("user_defined")) {
            this.userDefined.setSelected(true);
        } else {
            this.userDefined.setSelected(false);
            cl.show(this.cards, "");
        }
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        element.clear();
        this.configureTestElement(element);
        element.setProperty("servername", this.servername.getText());
        element.setProperty("port", this.port.getText());
        element.setProperty("rootdn", this.rootdn.getText());
        element.setProperty((JMeterProperty)new BooleanProperty("user_defined", this.userDefined.isSelected()));
        if (this.addTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "add"));
            element.setProperty((JMeterProperty)new StringProperty("base_entry_dn", this.add.getText()));
            element.setProperty((JMeterProperty)new TestElementProperty("arguments", this.tableAddPanel.createTestElement()));
        }
        if (this.modifyTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "modify"));
            element.setProperty((JMeterProperty)new StringProperty("base_entry_dn", this.modify.getText()));
            element.setProperty((JMeterProperty)new TestElementProperty("arguments", this.tableModifyPanel.createTestElement()));
        }
        if (this.deleteTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "delete"));
            element.setProperty((JMeterProperty)new StringProperty("delete", this.delete.getText()));
        }
        if (this.searchTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "search"));
            element.setProperty((JMeterProperty)new StringProperty("search", this.searchbase.getText()));
            element.setProperty((JMeterProperty)new StringProperty("searchfilter", this.searchfilter.getText()));
        }
    }

    public void clearGui() {
        super.clearGui();
        this.rootdn.setText("");
        this.searchbase.setText("");
        this.searchfilter.setText("");
        this.delete.setText("");
        this.add.setText("");
        this.modify.setText("");
        this.servername.setText("");
        this.port.setText("");
        this.userDefined.setSelected(false);
        this.addTest.setSelected(true);
        this.modifyTest.setSelected(false);
        this.deleteTest.setSelected(false);
        this.searchTest.setSelected(false);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        if (this.userDefined.isSelected()) {
            if (this.addTest.isSelected()) {
                cl.show(this.cards, "Add");
                this.tableModifyPanel.clear();
                this.modify.setText("");
                this.searchbase.setText("");
                this.searchfilter.setText("");
                this.delete.setText("");
            } else if (this.deleteTest.isSelected()) {
                cl.show(this.cards, "Delete");
                this.tableModifyPanel.clear();
                this.modify.setText("");
                this.tableAddPanel.clear();
                this.add.setText("");
                this.searchbase.setText("");
                this.searchfilter.setText("");
            } else if (this.searchTest.isSelected()) {
                cl.show(this.cards, "Search");
                this.delete.setText("");
                this.tableModifyPanel.clear();
                this.modify.setText("");
                this.tableAddPanel.clear();
                this.add.setText("");
            } else if (this.modifyTest.isSelected()) {
                cl.show(this.cards, "Modify");
                this.tableAddPanel.clear();
                this.add.setText("");
                this.searchbase.setText("");
                this.searchfilter.setText("");
                this.delete.setText("");
            } else {
                this.resetCardLayout(cl);
            }
        } else {
            this.resetCardLayout(cl);
        }
    }

    private void resetCardLayout(CardLayout cl) {
        cl.show(this.cards, "");
        this.tableAddPanel.clear();
        this.add.setText("");
        this.tableModifyPanel.clear();
        this.modify.setText("");
        this.searchbase.setText("");
        this.searchfilter.setText("");
        this.delete.setText("");
    }

    private JPanel createServernamePanel() {
        return LdapConfigGui.createLabelPanel("servername", this.servername);
    }

    private JPanel createPortPanel() {
        return LdapConfigGui.createLabelPanel("port", this.port);
    }

    private JPanel createRootdnPanel() {
        return LdapConfigGui.createLabelPanel("dn", this.rootdn);
    }

    private JPanel createSearchPanel() {
        VerticalPanel searchPanel = new VerticalPanel();
        searchPanel.add((Component)LdapConfigGui.createLabelPanel("search_base", this.searchbase));
        searchPanel.add((Component)LdapConfigGui.createLabelPanel("search_filter", this.searchfilter));
        return searchPanel;
    }

    private JPanel createDeletePanel() {
        VerticalPanel panel = new VerticalPanel();
        panel.add((Component)LdapConfigGui.createLabelPanel("delete", this.delete));
        return panel;
    }

    private JPanel createAddPanel() {
        JPanel addPanel = new JPanel(new BorderLayout(5, 0));
        addPanel.add((Component)LdapConfigGui.createLabelPanel("entry_dn", this.add), "North");
        addPanel.add((Component)this.tableAddPanel, "Center");
        return addPanel;
    }

    private static JPanel createLabelPanel(String key, JTextField field) {
        JPanel addInnerPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)key));
        label.setLabelFor(field);
        addInnerPanel.add((Component)label, "West");
        addInnerPanel.add((Component)field, "Center");
        return addInnerPanel;
    }

    private JPanel createModifyPanel() {
        JPanel modifyPanel = new JPanel(new BorderLayout(5, 0));
        modifyPanel.add((Component)LdapConfigGui.createLabelPanel("entry_dn", this.modify), "North");
        modifyPanel.add((Component)this.tableModifyPanel, "Center");
        return modifyPanel;
    }

    private JPanel testPanel() {
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)new JPanel(), "");
        this.cards.add((Component)this.createAddPanel(), "Add");
        this.cards.add((Component)this.createModifyPanel(), "Modify");
        this.cards.add((Component)this.createDeletePanel(), "Delete");
        this.cards.add((Component)this.createSearchPanel(), "Search");
        return this.cards;
    }

    private JPanel createTestPanel() {
        JPanel testPanel = new JPanel(new BorderLayout());
        testPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"test_configuration")));
        testPanel.add(new JLabel(JMeterUtils.getResString((String)"test")));
        JPanel rowPanel = new JPanel();
        rowPanel.add(this.addTest);
        this.bGroup.add(this.addTest);
        rowPanel.add(this.deleteTest);
        this.bGroup.add(this.deleteTest);
        rowPanel.add(this.searchTest);
        this.bGroup.add(this.searchTest);
        rowPanel.add(this.modifyTest);
        this.bGroup.add(this.modifyTest);
        testPanel.add((Component)rowPanel, "North");
        testPanel.add((Component)this.userDefined, "Center");
        return testPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add((Component)this.createServernamePanel());
        mainPanel.add((Component)this.createPortPanel());
        mainPanel.add((Component)this.createRootdnPanel());
        mainPanel.add((Component)this.createTestPanel());
        mainPanel.add((Component)this.testPanel());
        this.add((Component)mainPanel, "Center");
        this.userDefined.addItemListener(this);
        this.addTest.addItemListener(this);
        this.modifyTest.addItemListener(this);
        this.deleteTest.addItemListener(this);
        this.searchTest.addItemListener(this);
    }
}

