/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import com.google.auto.service.AutoService;
import javax.swing.JEditorPane;
import javax.swing.text.ComponentView;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ResultRenderer.class})
public class RenderAsHTML
extends SamplerResultTab
implements ResultRenderer {
    private static final Logger log = LoggerFactory.getLogger(RenderAsHTML.class);
    private static final String TEXT_HTML = "text/html";
    private static final EditorKit customisedEditor = new LocalHTMLEditorKit();
    private static final EditorKit defaultHtmlEditor = JEditorPane.createEditorKitForContentType("text/html");

    @Override
    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.showRenderedResponse(response, sampleResult);
    }

    protected void showRenderedResponse(String response, SampleResult res) {
        this.showRenderedResponse(response, res, false);
    }

    protected void showRenderedResponse(String response, SampleResult res, boolean embedded) {
        if (response == null) {
            this.results.setText("");
            return;
        }
        int htmlIndex = response.indexOf("<HTML");
        if (htmlIndex < 0) {
            htmlIndex = response.indexOf("<html");
        }
        if (htmlIndex < 0) {
            htmlIndex = 0;
        }
        String html = response.substring(htmlIndex);
        this.results.setEditorKitForContentType(TEXT_HTML, embedded ? defaultHtmlEditor : customisedEditor);
        this.results.setContentType(TEXT_HTML);
        if (embedded) {
            this.results.getDocument().putProperty("stream", res.getURL());
        }
        this.results.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        try {
            this.results.setText(html);
        }
        catch (RuntimeException rte) {
            this.results.setText("Failed to parse HTML: " + rte.getMessage());
        }
        this.results.setCaretPosition(0);
        try {
            this.resultsScrollPane.setViewportView(this.results);
        }
        catch (NumberFormatException e) {
            log.warn("An error occurred rendering html code", (Throwable)e);
            this.results.setText("Failed to render HTML: " + e.getMessage() + ", use Text renderer");
        }
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"view_results_render_html");
    }

    private static class LocalHTMLEditorKit
    extends HTMLEditorKit {
        private static final long serialVersionUID = -3399554318202905392L;
        private static final ViewFactory defaultFactory = new LocalHTMLFactory();

        private LocalHTMLEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return defaultFactory;
        }

        private static class LocalHTMLFactory
        extends HTMLEditorKit.HTMLFactory {
            private LocalHTMLFactory() {
            }

            @Override
            public View create(Element elem) {
                Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (o instanceof HTML.Tag) {
                    HTML.Tag kind = (HTML.Tag)o;
                    if (kind == HTML.Tag.FRAME) {
                        return new ComponentView(elem);
                    }
                    if (kind == HTML.Tag.IMG) {
                        return new ComponentView(elem);
                    }
                }
                return super.create(elem);
            }
        }
    }
}

