/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.control.ForeachController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="foreach_controller_title")
public class ForeachControlPanel
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JTextField inputVal;
    private JTextField startIndex;
    private JTextField endIndex;
    private JTextField returnVal;
    private JCheckBox useSeparator;
    private boolean displayName = true;
    private static final String INPUT_VAL_NAME = "Input Field";
    private static final String RETURN_VAL_NAME = "Return Field";
    private static final String START_INDEX_NAME = "Start Index Field";
    private static final String END_INDEX_NAME = "End Index Field";

    public ForeachControlPanel() {
        this(true);
    }

    public ForeachControlPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.inputVal.setText(((ForeachController)element).getInputValString());
        this.startIndex.setText(((ForeachController)element).getStartIndexAsString());
        this.endIndex.setText(((ForeachController)element).getEndIndexAsString());
        this.returnVal.setText(((ForeachController)element).getReturnValString());
        this.useSeparator.setSelected(((ForeachController)element).getUseSeparator());
    }

    public TestElement createTestElement() {
        ForeachController lc = new ForeachController();
        this.modifyTestElement((TestElement)lc);
        return lc;
    }

    public void modifyTestElement(TestElement lc) {
        this.configureTestElement(lc);
        if (lc instanceof ForeachController) {
            ForeachController fec = (ForeachController)lc;
            fec.setInputVal(this.inputVal.getText());
            fec.setStartIndex(this.startIndex.getText());
            fec.setEndIndex(this.endIndex.getText());
            fec.setReturnVal(this.returnVal.getText());
            fec.setUseSeparator(this.useSeparator.isSelected());
        }
    }

    public void clearGui() {
        super.clearGui();
        this.inputVal.setText("");
        this.startIndex.setText("");
        this.endIndex.setText("");
        this.returnVal.setText("");
        this.useSeparator.setSelected(true);
    }

    public String getLabelResource() {
        return "foreach_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createLoopCountPanel(), "North");
            this.add(mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.createLoopCountPanel(), "North");
        }
    }

    private JPanel createLoopCountPanel() {
        JPanel loopPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        this.inputVal = new JTextField("", 5);
        loopPanel.add(JMeterUtils.labelFor((Component)this.inputVal, (String)"foreach_input"));
        this.inputVal.setName(INPUT_VAL_NAME);
        loopPanel.add(this.inputVal);
        this.startIndex = new JTextField("", 5);
        loopPanel.add(JMeterUtils.labelFor((Component)this.startIndex, (String)"foreach_start_index"));
        this.startIndex.setName(START_INDEX_NAME);
        loopPanel.add(this.startIndex);
        this.endIndex = new JTextField("", 5);
        loopPanel.add(JMeterUtils.labelFor((Component)this.endIndex, (String)"foreach_end_index"));
        this.endIndex.setName(END_INDEX_NAME);
        loopPanel.add(this.endIndex);
        this.returnVal = new JTextField("", 5);
        loopPanel.add(JMeterUtils.labelFor((Component)this.returnVal, (String)"foreach_output"));
        this.returnVal.setName(RETURN_VAL_NAME);
        loopPanel.add(this.returnVal);
        this.useSeparator = new JCheckBox(JMeterUtils.getResString((String)"foreach_use_separator"), true);
        loopPanel.add((Component)this.useSeparator, "span 2");
        return loopPanel;
    }
}

