/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InnerOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalFluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SignalType;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class FluxDoFinally<T>
extends InternalFluxOperator<T, T> {
    final Consumer<SignalType> onFinally;

    static <T> CoreSubscriber<T> createSubscriber(CoreSubscriber<? super T> s, Consumer<SignalType> onFinally) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            return new DoFinallyConditionalSubscriber((Fuseable.ConditionalSubscriber)s, onFinally);
        }
        return new DoFinallySubscriber<T>(s, onFinally);
    }

    FluxDoFinally(Flux<? extends T> source, Consumer<SignalType> onFinally) {
        super(source);
        this.onFinally = onFinally;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return FluxDoFinally.createSubscriber(actual, this.onFinally);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class DoFinallyConditionalSubscriber<T>
    extends DoFinallySubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        DoFinallyConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Consumer<SignalType> onFinally) {
            super(actual, onFinally);
        }

        @Override
        public boolean tryOnNext(T t) {
            return ((Fuseable.ConditionalSubscriber)this.actual).tryOnNext(t);
        }
    }

    static class DoFinallySubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Consumer<SignalType> onFinally;
        volatile int once;
        static final AtomicIntegerFieldUpdater<DoFinallySubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(DoFinallySubscriber.class, "once");
        Subscription s;

        DoFinallySubscriber(CoreSubscriber<? super T> actual, Consumer<SignalType> onFinally) {
            this.actual = actual;
            this.onFinally = onFinally;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return this.once == 1;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            try {
                this.actual.onError(t);
            }
            finally {
                this.runFinally(SignalType.ON_ERROR);
            }
        }

        public void onComplete() {
            this.actual.onComplete();
            this.runFinally(SignalType.ON_COMPLETE);
        }

        public void cancel() {
            this.s.cancel();
            this.runFinally(SignalType.CANCEL);
        }

        public void request(long n) {
            this.s.request(n);
        }

        void runFinally(SignalType signalType) {
            if (ONCE.compareAndSet(this, 0, 1)) {
                try {
                    this.onFinally.accept(signalType);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    Operators.onErrorDropped(ex, this.actual.currentContext());
                }
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }
    }
}

