/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotSvgHelper;", "", "()V", "extractDouble", "", "regex", "Lkotlin/text/Regex;", "text", "", "fetchPlotSizeFromSvg", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "svg", "plot-stem"})
public final class PlotSvgHelper {
    @NotNull
    public static final PlotSvgHelper INSTANCE = new PlotSvgHelper();

    private PlotSvgHelper() {
    }

    @NotNull
    public final DoubleVector fetchPlotSizeFromSvg(@NotNull String svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        MatchResult svgTagMatch = Regex.find$default((Regex)new Regex("<svg (.*)>"), (CharSequence)svg, (int)0, (int)2, null);
        if (!(svgTagMatch != null && svgTagMatch.getGroupValues().size() == 2)) {
            boolean $i$a$-require-PlotSvgHelper$fetchPlotSizeFromSvg$22 = false;
            String $i$a$-require-PlotSvgHelper$fetchPlotSizeFromSvg$22 = "Couldn't find 'svg' tag";
            throw new IllegalArgumentException($i$a$-require-PlotSvgHelper$fetchPlotSizeFromSvg$22.toString());
        }
        String svgTag = (String)svgTagMatch.getGroupValues().get(1);
        double width = this.extractDouble(new Regex(".*width=\"(\\d+)\\.?(\\d+)?\""), svgTag);
        double height = this.extractDouble(new Regex(".*height=\"(\\d+)\\.?(\\d+)?\""), svgTag);
        return new DoubleVector(width, height);
    }

    private final double extractDouble(Regex regex, String text) {
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)text, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        MatchResult matchResult2 = matchResult;
        List values = matchResult2.getGroupValues();
        return values.size() < 3 ? Double.parseDouble(String.valueOf(values.get(1))) : Double.parseDouble((String)values.get(1) + '.' + (String)values.get(2));
    }
}

