/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.conversion;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.function.Function;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.spec.conversion.SystemColor;
import org.jetbrains.letsPlot.core.spec.conversion.TypedContinuousIdentityMappers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \n2\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001\nB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/spec/conversion/ColorOptionConverter;", "Lorg/jetbrains/letsPlot/commons/intern/function/Function;", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "pen", "paper", "brush", "(Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/commons/values/Color;)V", "apply", "value", "Companion", "plot-stem"})
public final class ColorOptionConverter
implements Function<Object, Color> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Color pen;
    @NotNull
    private final Color paper;
    @NotNull
    private final Color brush;
    @NotNull
    private static final ColorOptionConverter demoAndTest = new ColorOptionConverter(Color.Companion.getCYAN(), Color.Companion.getCYAN(), Color.Companion.getCYAN());

    public ColorOptionConverter(@NotNull Color pen, @NotNull Color paper, @NotNull Color brush) {
        Intrinsics.checkNotNullParameter((Object)pen, (String)"pen");
        Intrinsics.checkNotNullParameter((Object)paper, (String)"paper");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        this.pen = pen;
        this.paper = paper;
        this.brush = brush;
    }

    @Nullable
    public Color apply(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Color) {
            return (Color)value;
        }
        if (value instanceof Number) {
            return (Color)TypedContinuousIdentityMappers.INSTANCE.getCOLOR().invoke(Double.valueOf(((Number)value).doubleValue()));
        }
        String str = value.toString();
        if (SystemColor.Companion.canParse(str)) {
            Color color;
            switch (WhenMappings.$EnumSwitchMapping$0[SystemColor.Companion.parse(str).ordinal()]) {
                case 1: {
                    color = this.pen;
                    break;
                }
                case 2: {
                    color = this.paper;
                    break;
                }
                case 3: {
                    color = this.brush;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return color;
        }
        try {
            return Colors.INSTANCE.parseColor(str);
        }
        catch (RuntimeException ignored) {
            throw new IllegalArgumentException("Can't convert to color: '" + value + "' (" + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + ')');
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/spec/conversion/ColorOptionConverter$Companion;", "", "()V", "demoAndTest", "Lorg/jetbrains/letsPlot/core/spec/conversion/ColorOptionConverter;", "getDemoAndTest", "()Lorg/jetbrains/letsPlot/core/spec/conversion/ColorOptionConverter;", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorOptionConverter getDemoAndTest() {
            return demoAndTest;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SystemColor.values().length];
            try {
                nArray[SystemColor.PEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SystemColor.PAPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SystemColor.BRUSH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

